package eu.dnetlib.openaire.dsm.dao;

import java.util.List;
import java.util.Queue;

import com.google.common.collect.Lists;
import eu.dnetlib.openaire.dsm.domain.DatasourceResponse;
import eu.dnetlib.openaire.dsm.domain.Header;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.ApiDetailsResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceInfo;

public class ResponseUtils {

	public static DatasourceResponse datasourceResponse(final List<DatasourceInfo> datasourceInfo, final Queue<Throwable> errors, final long total) {
		final DatasourceResponse rsp = new DatasourceResponse().setDatasourceInfo(datasourceInfo);
		rsp.setHeader(getHeader(errors, total));
		return rsp;
	}

	public static ApiDetailsResponse apiResponse(final List<ApiDetails> api, final long total) {
		final ApiDetailsResponse rsp = new ApiDetailsResponse().setApi(api);
		rsp.setHeader(getHeader(Lists.newLinkedList(), total));
		return rsp;
	}

	private static Header getHeader(final Queue<Throwable> errors, final long total) {
		return Header.newInsance()
				.setExceptions(errors)
				.setTotal(total);
	}

}
