package eu.dnetlib.openaire.dsm.domain;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.dnetlib.enabling.datasources.common.AggregationInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
@ApiModel(value = "Datasource info model", description = "provides information about the datasource and its aggregation status")
public class DatasourceInfo {

	@ApiModelProperty(position = 0)
	private long indexRecords;

	@ApiModelProperty(position = 1)
	private long fundedContent;

	@ApiModelProperty(position = 2)
	private long fulltexts;

	@ApiModelProperty(position = 3)
	private String lastIndexingDate;

	@ApiModelProperty(position = 4)
	private DatasourceDetails datasource;

	@ApiModelProperty(position = 5)
	private AggregationInfo lastCollection;

	@ApiModelProperty(position = 6)
	private AggregationInfo lastTransformation;

	@ApiModelProperty(position = 7)
	private List<AggregationInfo> aggregationHistory;

	public DatasourceInfo() {
		super();
	}

	public DatasourceInfo setIndexRecords(final long indexRecords) {
		this.indexRecords = indexRecords;
		return this;
	}

	public DatasourceInfo setFundedContent(final long fundedContent) {
		this.fundedContent = fundedContent;
		return this;
	}

	public DatasourceInfo setFulltexts(final long fulltexts) {
		this.fulltexts = fulltexts;
		return this;
	}

	public DatasourceInfo setLastIndexingDate(final String lastIndexingDate) {
		this.lastIndexingDate = lastIndexingDate;
		return this;
	}

	public DatasourceInfo setAggregationHistory(final List<AggregationInfo> aggregationHistory) {
		this.aggregationHistory = aggregationHistory;
		return this;
	}

	public DatasourceInfo setLastCollection(final AggregationInfo lastCollection) {
		this.lastCollection = lastCollection;
		return this;
	}

	public DatasourceInfo setLastTransformation(final AggregationInfo lastTransformation) {
		this.lastTransformation = lastTransformation;
		return this;
	}

	public long getIndexRecords() {
		return indexRecords;
	}

	public long getFundedContent() {
		return fundedContent;
	}

	public long getFulltexts() {
		return fulltexts;
	}

	public String getLastIndexingDate() {
		return lastIndexingDate;
	}

	public List<AggregationInfo> getAggregationHistory() {
		return aggregationHistory;
	}

	public AggregationInfo getLastCollection() {
		return lastCollection;
	}

	public AggregationInfo getLastTransformation() {
		return lastTransformation;
	}

	public DatasourceDetails getDatasource() {
		return datasource;
	}

	public DatasourceInfo setDatasource(final DatasourceDetails datasource) {
		this.datasource = datasource;
		return this;
	}

}
