package eu.dnetlib.openaire.dsm.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

@JsonAutoDetect
@ApiModel(value = "Organization info model", description = "provides information about the organization")
public class OrganizationDetails extends OrganizationIgnoredProperties {

	@ApiModelProperty(position = 0)
	private String legalshortname;

	@NotBlank
	@Length(max = 500)
	@ApiModelProperty(position = 1)
	private String legalname;

	@ApiModelProperty(position = 2)
	private String websiteurl;

	@ApiModelProperty(position = 3)
	private String logourl;

	@NotBlank
	@ApiModelProperty(position = 4)
	private String country;

	public String getLegalshortname() {
		return legalshortname;
	}

	public String getLegalname() {
		return legalname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public String getLogourl() {
		return logourl;
	}

	public String getCountry() {
		return country;
	}

	public OrganizationDetails setLegalshortname(final String legalshortname) {
		this.legalshortname = legalshortname;
		return this;
	}

	public OrganizationDetails setLegalname(final String legalname) {
		this.legalname = legalname;
		return this;
	}

	public OrganizationDetails setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
		return this;
	}

	public OrganizationDetails setLogourl(final String logourl) {
		this.logourl = logourl;
		return this;
	}

	public OrganizationDetails setCountry(final String country) {
		this.country = country;
		return this;
	}

}
