package eu.dnetlib.openaire.funders;

import java.util.List;
import java.util.stream.Collectors;

import eu.dnetlib.openaire.funders.domain.ConversionUtils;
import eu.dnetlib.openaire.funders.domain.ExtendedFunderDetails;
import eu.dnetlib.openaire.funders.domain.FunderDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

@Component
public class FunderDao {

	private static final Log log = LogFactory.getLog(FunderDao.class);

	@Autowired
	private FunderRepository funderRepository;

	public ExtendedFunderDetails getExtendedFunderDetails(final String funderId) throws FundersApiException {
		return ConversionUtils.asExtendedFunderDetails(funderRepository.getOne(funderId));
	}

	public List<FunderDetails> listFunderDetails(final int page, final int size) throws FundersApiException {
		return funderRepository.findAll(new PageRequest(page, size))
				.getContent()
				.stream()
				.map(ConversionUtils::asFunderDetails)
				.collect(Collectors.toList());
	}

	public List<String> listFunderIds(final int page, final int size) throws FundersApiException {
		return funderRepository.findAll(new PageRequest(page, size))
				.getContent()
				.stream()
				.map(f -> f.getId())
				.collect(Collectors.toList());
	}

}
