/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.common;

import com.google.common.collect.Lists;
import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.common.OperationManager;
import eu.dnetlib.openaire.common.Utils;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.context.ContextMappingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class ISClientImpl
implements ISClient {
    private static final Log log = LogFactory.getLog(ISClientImpl.class);
    @Autowired
    private OpenaireExporterConfig config;
    @Autowired
    private ISLookUpService isLookUpService;
    @Autowired
    private OperationManager operationManager;

    @Cacheable(value={"objectstoreid-cache"})
    public String getObjectStoreId(String dsId) throws DsmException {
        log.warn((Object)String.format("getObjectStoreId(%s): not using cache", dsId));
        try {
            String xqueryTemplate = this._getQuery(this.config.getFindObjectStore());
            return this._isLookUp(String.format(xqueryTemplate, dsId));
        }
        catch (ISLookUpException | IOException e) {
            throw new DsmException("unble to find objectstore for ds " + dsId);
        }
    }

    @Cacheable(value={"context-cache"})
    public Map<String, Context> getFunderContextMap() throws IOException {
        return this._processContext(this._getQuery(this.config.getFindFunderContexts()));
    }

    @Cacheable(value={"context-cache"})
    public Map<String, Context> getCommunityContextMap() throws IOException {
        return this._processContext(this._getQuery(this.config.getFindCommunityContexts()));
    }

    @Cacheable(value={"context-cache"})
    public Map<String, Context> getContextMap() throws IOException {
        return this._processContext(this._getQuery(this.config.getFindContextProfiles()));
    }

    @CacheEvict(value={"context-cache"}, allEntries=true)
    public void updateContextParam(String id, String name, String value) {
        LinkedList errors = Lists.newLinkedList();
        this._quickSeachProfile(this.getXQuery(id, name, value), (Queue)errors);
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error(e));
        }
    }

    @CacheEvict(value={"context-cache"}, allEntries=true)
    public void updateContextAttribute(String id, String name, String value) {
        LinkedList errors = Lists.newLinkedList();
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        this._quickSeachProfile(String.format("update value collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/@%s with '%s'", id, name, Utils.escape((Escaper)esc, (String)value)), (Queue)errors);
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error(e));
        }
    }

    @CacheEvict(value={"context-cache"}, allEntries=true)
    public void addConcept(String id, String categoryId, String data) {
        LinkedList errors = Lists.newLinkedList();
        this._quickSeachProfile(String.format("update insert %s into collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/category[./@id = '%s']", data, id, categoryId), (Queue)errors);
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error(e));
        }
    }

    @CacheEvict(value={"context-cache"}, allEntries=true)
    public void removeConcept(String id, String categoryId, String conceptId) {
        LinkedList errors = Lists.newLinkedList();
        this._quickSeachProfile(String.format("for $concept in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/category[./@id = '%s']/concept[./@id = '%s']return update delete $concept", id, categoryId, conceptId), (Queue)errors);
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error((Object)e.getMessage()));
        }
    }

    public void updateDatasourceFields(String dsId, Map<String, String> changes) {
        LinkedList errors = Lists.newLinkedList();
        this.operationManager.addOperation(() -> {
            Thread.currentThread().setName("update-ds:" + dsId);
            changes.forEach((xpath, value) -> {
                try {
                    this._isLookUp(String.format("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')\nwhere $x/RESOURCE_PROFILE/BODY/CONFIGURATION/DATASOURCE_ORIGINAL_ID[@provenance='OPENAIRE']/text() = '%s'\nreturn update value $x%s with '%s'", dsId, xpath, value));
                }
                catch (ISLookUpException e) {
                    errors.add(e);
                }
            });
        });
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error((Object)e.getMessage()));
        }
    }

    public void addAPIAttribute(String dsId, String apiId, Map<String, String> changes) {
        LinkedList errors = Lists.newLinkedList();
        this.operationManager.addOperation(() -> {
            Thread.currentThread().setName("update-api:" + dsId);
            changes.forEach((xpath, value) -> {
                try {
                    String attribute = StringUtils.substringAfter((String)xpath, (String)"@");
                    String parentElement = StringUtils.substringBeforeLast((String)xpath, (String)"/");
                    this._isLookUp(String.format("let $x:=/RESOURCE_PROFILE/BODY/CONFIGURATION/DATASOURCE_ORIGINAL_ID[@provenance='OPENAIRE' and ./text() = '%s']\nreturn update insert attribute %s {'%s'} into $x/..//INTERFACE[./@id = '%s']%s", dsId, attribute, value, apiId, parentElement));
                }
                catch (ISLookUpException e) {
                    errors.add(e);
                }
            });
        });
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error((Object)e.getMessage()));
        }
    }

    public void updateAPIField(String dsId, String apiId, Map<String, String> changes) {
        LinkedList errors = Lists.newLinkedList();
        this.operationManager.addOperation(() -> {
            Thread.currentThread().setName("update-api:" + dsId);
            changes.forEach((xpath, value) -> {
                try {
                    this._isLookUp(String.format("let $x:=/RESOURCE_PROFILE/BODY/CONFIGURATION/DATASOURCE_ORIGINAL_ID[@provenance='OPENAIRE' and ./text() = '%s']\nreturn update value $x/..//INTERFACE[./@id = '%s']%s with '%s'", dsId, apiId, xpath, value));
                }
                catch (ISLookUpException e) {
                    errors.add(e);
                }
            });
        });
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error((Object)e.getMessage()));
        }
    }

    public void removeAPI(String apiId) throws DsmForbiddenException {
        LinkedList errors = Lists.newLinkedList();
        try {
            List metaWorkflows = this._quickSeachProfile(String.format("distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType')\nwhere $x/RESOURCE_PROFILE/BODY/DATAPROVIDER[./@interface = '%s']\nreturn $x/RESOURCE_PROFILE/BODY/DATAPROVIDER/@id/string())", apiId), (Queue)errors);
            if (!metaWorkflows.isEmpty()) {
                throw new DsmForbiddenException(403, String.format("cannot remove api '%s', it has workflows associated", apiId));
            }
            this._isLookUp(String.format("update delete /RESOURCE_PROFILE/BODY/CONFIGURATION/INTERFACES/INTERFACE[./@id = '%s']", apiId));
            log.debug((Object)String.format("deleted API %s", apiId));
        }
        catch (ISLookUpException e2) {
            errors.add(e2);
        }
        if (!errors.isEmpty()) {
            errors.forEach(e -> log.error((Object)e.getMessage()));
        }
    }

    private String getXQuery(String id, String name, String value) {
        Escaper esc = XmlEscapers.xmlContentEscaper();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/param[./@name = '%s'] with <param name='%s'>%s</param>", id, name, name, Utils.escape((Escaper)esc, (String)value));
        }
        return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/param[./@name = '%s'] with <param name='%s'/>", id, name, name);
    }

    private Map<String, Context> _processContext(String xquery) throws IOException {
        return this._processContext(new LinkedBlockingQueue(), xquery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Context> _processContext(Queue<Throwable> errors, String xquery) throws IOException {
        try {
            Map<String, Context> map = this.getContextProfiles(errors, xquery).stream().filter(StringUtils::isNotBlank).map(s -> ContextMappingUtils.parseContext((String)s, (Queue)errors)).collect(Collectors.toMap(Context::getId, Function.identity(), (c1, c2) -> {
                log.warn((Object)String.format("found duplicate context profile '%s'", c1.getId()));
                return c1;
            }));
            return map;
        }
        finally {
            if (!errors.isEmpty()) {
                log.error(errors);
                errors.forEach(e -> e.printStackTrace());
            }
        }
    }

    private List<String> getContextProfiles(Queue<Throwable> errors, String xquery) throws IOException {
        log.warn((Object)"getContextProfiles(): not using cache");
        return this._quickSeachProfile(xquery, errors);
    }

    private String _getQuery(ClassPathResource resource) throws IOException {
        return IOUtils.toString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
    }

    private String _isLookUp(String xquery) throws ISLookUpException {
        log.debug((Object)String.format("running xquery:\n%s", xquery));
        String res = this.isLookUpService.getResourceProfileByQuery(xquery);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> _quickSeachProfile(String xquery, Queue<Throwable> errors) {
        ArrayList res = Lists.newArrayList();
        try {
            log.debug((Object)String.format("running xquery:\n%s", xquery));
            List list = this.isLookUpService.quickSearchProfile(xquery);
            if (list != null) {
                res.addAll(list);
            }
            log.debug((Object)String.format("query result size: %s", res.size()));
        }
        catch (Throwable e) {
            errors.add(e);
            ArrayList arrayList = Lists.newArrayList();
            return arrayList;
        }
        finally {
            return res;
        }
    }

    @CacheEvict(cacheNames={"context-cache", "indexdsinfo-cache", "objectstoreid-cache"}, allEntries=true)
    public void dropCache() {
        log.info((Object)"dropped dsManager IS cache");
    }
}

