package eu.dnetlib.openaire.community;

import java.util.Set;

import com.google.common.collect.Sets;

public class CommunityConstants {

	public final static Set<String> communityBlackList = Sets.newHashSet("fet-fp7", "fet-h2020");

	// common
	public final static String OPENAIRE_ID = "openaireId";
	public final static String PIPE_SEPARATOR = "||";
	public final static String ID_SEPARATOR = "::";
	public final static String CSV_DELIMITER = ",";
	public final static String CLABEL = "label";

	// id suffixes
	public final static String PROJECTS_ID_SUFFIX = ID_SEPARATOR + "projects";
	public final static String CONTENTPROVIDERS_ID_SUFFIX = ID_SEPARATOR + "contentproviders";

	// community summary
	public final static String CSUMMARY_DESCRIPTION = "description";
	public final static String CSUMMARY_LOGOURL = "logourl";
	public final static String CSUMMARY_STATUS = "status";
	public final static String CSUMMARY_NAME = "name";
	public final static String CSUMMARY_MANAGER = "manager";

	// community profile
	public final static String CPROFILE_SUBJECT = "subject";

	// community project
	public final static String CPROJECT_FUNDER = "funder";
	public final static String CPROJECT_NUMBER = "CD_PROJECT_NUMBER";
	public final static String CPROJECT_FULLNAME = "projectfullname";
	public final static String CPROJECT_ACRONYM = "projectacronym";

	// community content provider
	public final static String CCONTENTPROVIDER_NAME = "name";
	public final static String CCONTENTPROVIDER_OFFICIALNAME = "officialname";

}
