package eu.dnetlib;

import eu.dnetlib.OpenaireExporterConfig.Swagger;

import eu.dnetlib.openaire.community.CommunityApiController;
import eu.dnetlib.openaire.context.ContextApiController;
import eu.dnetlib.openaire.project.ProjectsController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import static springfox.documentation.builders.RequestHandlerSelectors.basePackage;

@Configuration
@EnableSwagger2
public class SwaggerConfig {

	private static final Log log = LogFactory.getLog(SwaggerConfig.class);

	public static String V1 = "1.0.0";

	@Autowired
	private OpenaireExporterConfig config;

	@Bean
	public Docket projects() {
		return _docket(
				"OpenAIRE Projects",
				ProjectsController.class.getPackage().getName(),
				config.getSwaggerProjects(),
				V1);
	}

	@Bean
	public Docket communities() {
		return _docket(
				"OpenAIRE Communities",
				CommunityApiController.class.getPackage().getName(),
				config.getSwaggerCommunities(),
				V1);
	}

	@Bean
	public Docket contexts() {
		return _docket(
				"OpenAIRE Contexts",
				ContextApiController.class.getPackage().getName(),
				config.getSwaggerCommunities(),
				V1);
	}

	private Docket _docket(final String groupName, final String controllerPackage, final Swagger swag, final String version) {
		return new Docket(DocumentationType.SWAGGER_2)
				.groupName(groupName)
				.select()
				.apis(basePackage(controllerPackage))
				.build()
				.directModelSubstitute(org.joda.time.LocalDate.class, java.sql.Date.class)
				.directModelSubstitute(org.joda.time.DateTime.class, java.util.Date.class)
				.apiInfo(apiInfo(swag, version));
	}

	private ApiInfo apiInfo(final Swagger swag, final String version) {
		return new ApiInfoBuilder()
				.title(swag.getApiTitle())
				.description(swag.getApiDescription())
				.license(swag.getApiLicense())
				.licenseUrl(swag.getApiLicenseUrl())
				.termsOfServiceUrl("")
				.version(version)
				.contact(new Contact(
						swag.getApiContactName(),
						swag.getApiContactUrl(),
						swag.getApiContactEmail()))
				.build();
	}

}
