package eu.dnetlib.openaire.common;

import java.io.IOException;
import java.util.Map;

import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.openaire.context.Context;

public interface ISClient {

	String getObjectStoreId(String dsId) throws DsmException;

	Map<String, Context> getFunderContextMap() throws IOException;

	Map<String, Context> getCommunityContextMap() throws IOException;

	Map<String, Context> getContextMap() throws IOException;

	void updateContextParam(String id, String name, String value);

	void updateContextAttribute(String id, String name, String value);

	void addConcept(String id, String categoryId, String data);

	void removeConcept(String id, String categoryId, String conceptId);

	void updateDatasourceFields(String dsId, Map<String, String> changes);

	void addAPIAttribute(String dsId, String apiId, Map<String, String> changes);

	void updateAPIField(String dsId, String apiId, Map<String, String> changes);

	void removeAPI(String apiId) throws DsmForbiddenException;

	void dropCache();

}
