/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.context;

import eu.dnetlib.openaire.context.CategorySummary;
import eu.dnetlib.openaire.context.ConceptSummary;
import eu.dnetlib.openaire.context.ContextApiCore;
import eu.dnetlib.openaire.context.ContextException;
import eu.dnetlib.openaire.context.ContextSummary;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.context"}, havingValue="true")
@Api(tags={"OpenAIRE Context API"}, description="the OpenAIRE Context API")
public class ContextApiController {
    @Autowired
    private ContextApiCore contextApiCore;

    @RequestMapping(value={"/contexts"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="list brief information about all the context profiles", notes="list brief information about all the context profiles.", tags={}, response=ContextSummary[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ContextSummary[].class), @ApiResponse(code=500, message="unexpected error", response=ContextException.class)})
    public List<ContextSummary> listContexts() throws ContextException {
        return this.contextApiCore.listContexts();
    }

    @RequestMapping(value={"/context/{contextId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="list the categories defined within a context", notes="list the categories defined within a context", tags={}, response=CategorySummary[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CategorySummary[].class), @ApiResponse(code=500, message="unexpected error", response=ContextException.class)})
    public List<CategorySummary> listCategories(@PathVariable String contextId) throws ContextException {
        return this.contextApiCore.listCategories(contextId);
    }

    @RequestMapping(value={"/context/category/{categoryId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="list the concepts defined within a category", notes="list the concepts defined within a category", tags={}, response=ConceptSummary[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConceptSummary[].class), @ApiResponse(code=500, message="unexpected error", response=ContextException.class)})
    public List<ConceptSummary> listConcepts(@PathVariable String categoryId) throws ContextException {
        return this.contextApiCore.listConcepts(categoryId);
    }

    @RequestMapping(value={"/context/category/concept/{conceptId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="list the concepts defined within a category", notes="list the concepts defined within a category", tags={}, response=ConceptSummary[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConceptSummary[].class), @ApiResponse(code=500, message="unexpected error", response=ContextException.class)})
    public List<ConceptSummary> listSubConcepts(@PathVariable String conceptId) throws ContextException {
        return this.contextApiCore.listSubConcepts(conceptId);
    }
}

