/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.dsm.domain.DatasourceSnippet;
import eu.dnetlib.openaire.dsm.domain.OrganizationDetails;
import eu.dnetlib.openaire.dsm.domain.db.ApiDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceDbEntry;
import java.beans.PropertyDescriptor;
import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class DsmMappingUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String ID_SEPARATOR = "::";
    public static final String ID_PREFIX = "api_________::";

    public static String createId(ApiDetails api) {
        return "api_________::" + api.getDatasource() + "::" + RandomStringUtils.randomAlphanumeric((int)8);
    }

    public static DatasourceDetails asDetails(DatasourceDbEntry d) {
        DatasourceDetails details = (DatasourceDetails)DsmMappingUtils._convert((Object)d, DatasourceDetails.class);
        return details.setOpenaireId(DsmMappingUtils.asOpenaireId((String)details.getId()));
    }

    public static DatasourceSnippet asSnippet(DatasourceDbEntry d) {
        DatasourceSnippet ds = new DatasourceSnippet();
        ds.setId(d.getId());
        ds.setOfficialname(d.getOfficialname());
        ds.setEnglishname(d.getEnglishname());
        ds.setRegisteredby(d.getRegisteredby());
        ds.setWebsiteurl(d.getWebsiteurl());
        return ds;
    }

    public static ApiDetails asDetails(ApiDbEntry d) {
        return (ApiDetails)DsmMappingUtils._convert((Object)d, ApiDetails.class);
    }

    public static ApiDbEntry asDbEntry(ApiDetails d) {
        ApiDbEntry apiDbEntry = (ApiDbEntry)DsmMappingUtils._convert((Object)d, ApiDbEntry.class);
        apiDbEntry.getApiParams().forEach(ap -> ap.getId().setApi((Api)apiDbEntry));
        return apiDbEntry;
    }

    public static DatasourceDbEntry asDbEntry(DatasourceDetails d) {
        DatasourceDbEntry dbe = (DatasourceDbEntry)DsmMappingUtils._convert((Object)d, DatasourceDbEntry.class);
        if (dbe.getOrganizations() != null) {
            dbe.getOrganizations().forEach(o -> {
                o.setId(dbe.getId() + "::" + o.getLegalname());
                if (o.getDateofcollection() == null) {
                    o.setDateofcollection(new Date(System.currentTimeMillis()));
                }
            });
        }
        return dbe;
    }

    public static DatasourceDbEntry asDbEntry(DatasourceDetailsUpdate d) {
        return (DatasourceDbEntry)DsmMappingUtils._convert((Object)d, DatasourceDbEntry.class);
    }

    public static String asRepositoryProfile(DatasourceDetails ds) {
        Element root = DocumentHelper.createElement((String)"RESOURCE_PROFILE");
        Element header = root.addElement("HEADER");
        header.addElement("RESOURCE_IDENTIFIER").addAttribute("value", "");
        header.addElement("RESOURCE_TYPE").addAttribute("value", "RepositoryServiceResourceType");
        header.addElement("RESOURCE_KIND").addAttribute("value", "RepositoryServiceResources");
        header.addElement("RESOURCE_URI").addAttribute("value", "");
        header.addElement("DATE_OF_CREATION").addAttribute("value", DateUtils.now_ISO8601());
        header.addElement("PROTOCOL");
        Element body = root.addElement("BODY");
        Element conf = body.addElement("CONFIGURATION");
        conf.addElement("DATASOURCE_TYPE").setText(ds.getTypology());
        Element origId = conf.addElement("DATASOURCE_ORIGINAL_ID");
        origId.addAttribute("provenance", "D-NET");
        origId.setText(ds.getId());
        conf.addElement("DATASOURCE_AGGREGATED").setText("false");
        conf.addElement("ENVIRONMENTS").addElement("ENVIRONMENT").setText("OPENAIRE");
        conf.addElement("TYPOLOGY").setText("" + ds.getTypology());
        conf.addElement("MAX_SIZE_OF_DATASTRUCTURE").setText("0");
        conf.addElement("AVAILABLE_DISKSPACE").setText("0");
        conf.addElement("MAX_NUMBER_OF_DATASTRUCTURE").setText("0");
        String officialName = ds.getOfficialname();
        conf.addElement("OFFICIAL_NAME").setText(officialName);
        String englishName = ds.getEnglishname();
        conf.addElement("ENGLISH_NAME").setText(StringUtils.isNotBlank((CharSequence)englishName) ? englishName : officialName);
        conf.addElement("ICON_URI").setText("" + ds.getLogourl());
        OrganizationDetails org = DsmMappingUtils.getOrganization((DatasourceDetails)ds);
        conf.addElement("COUNTRY").setText(org != null ? org.getCountry() : "");
        Element location = conf.addElement("LOCATION");
        location.addElement("LONGITUDE").setText("" + ds.getLongitude());
        location.addElement("LATITUDE").setText("" + ds.getLatitude());
        location.addElement("TIMEZONE").setText("" + ds.getTimezone());
        conf.addElement("REPOSITORY_WEBPAGE").setText(ds.getWebsiteurl());
        DsmMappingUtils.getOrganization((DatasourceDetails)ds);
        conf.addElement("REPOSITORY_INSTITUTION").setText(org != null ? org.getLegalname() : "");
        conf.addElement("ADMIN_INFO").setText(ds.getContactemail());
        conf.addElement("INTERFACES");
        Element extraFields = conf.addElement("EXTRA_FIELDS");
        DsmMappingUtils.addExtraField((Element)extraFields, (String)"ACTIVATION_ID", (String)ds.getActivationId());
        DsmMappingUtils.addExtraField((Element)extraFields, (String)"NamespacePrefix", (String)ds.getNamespaceprefix());
        DsmMappingUtils.addExtraField((Element)extraFields, (String)"aggregatorName", (String)ds.getAggregator());
        DsmMappingUtils.addExtraField((Element)extraFields, (String)"dateOfCollection", (String)("" + ds.getDateofcollection()));
        DsmMappingUtils.addExtraField((Element)extraFields, (String)"dateOfValidation", (String)("" + ds.getDateofvalidation()));
        conf.addElement("REGISTERED_BY").setText(ds.getRegisteredby());
        Element status = body.addElement("STATUS");
        status.addElement("NUMBER_OF_OBJECTS").setText("0");
        status.addElement("LAST_UPDATE").addAttribute("value", DateUtils.now_ISO8601());
        Element qos = body.addElement("QOS");
        qos.addElement("AVAILABILITY").setText("0");
        qos.addElement("CAPACITY");
        qos.addElement("THROUGHPUT").setText("0");
        body.addElement("SECURITY_PARAMETERS");
        body.addElement("BLACKBOARD");
        return root.asXML();
    }

    public static String asRepositoryInterfce(ApiDetails api) {
        Element iface = DocumentHelper.createElement((String)"INTERFACE");
        iface.addAttribute("active", String.valueOf(api.getActive())).addAttribute("compliance", api.getCompatibility()).addAttribute("contentDescription", api.getContentdescription()).addAttribute("id", api.getId()).addAttribute("label", String.format("%s (%s)", api.getTypology(), api.getCompatibility())).addAttribute("removable", String.valueOf(api.getRemovable())).addAttribute("typology", api.getTypology());
        iface.addElement("ACCESS_PROTOCOL").setText(api.getProtocol());
        if (api.getApiParams() != null) {
            Element accessProtocol = (Element)iface.selectSingleNode("./ACCESS_PROTOCOL");
            api.getApiParams().forEach(ap -> {
                if ("format".equals(ap.getParam())) {
                    accessProtocol.addAttribute("format", ap.getValue());
                }
                if ("set".equals(ap.getParam())) {
                    accessProtocol.addAttribute("set", ap.getValue());
                }
            });
        }
        iface.addElement("BASE_URL").setText(api.getBaseurl());
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_collection_date");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_collection_mdId");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_collection_total");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_aggregation_date");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_aggregation_mdId");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_aggregation_total");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "metadata_identifier_path");
        return iface.asXML();
    }

    private static <T> T _convert(Object o, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.convertValue(o, clazz);
    }

    private static OrganizationDetails getOrganization(DatasourceDetails ds) {
        if (ds.getOrganizations() != null && !ds.getOrganizations().isEmpty()) {
            return (OrganizationDetails)ds.getOrganizations().stream().findFirst().get();
        }
        return null;
    }

    private static void addExtraField(Element extraFields, String field, String value) {
        Element f = extraFields.addElement("FIELD");
        f.addElement("key").setText(field);
        f.addElement("value").setText(value != null ? value : "");
    }

    private static String asOpenaireId(String id) {
        String prefix = StringUtils.substringBefore((String)id, (String)"::");
        String md5 = StringUtils.substringAfter((String)id, (String)"::");
        return prefix + "::" + AbstractDNetXsltFunctions.md5((String)md5);
    }

    public static void copyNonNullProperties(Object src, Object target) {
        BeanUtils.copyProperties((Object)src, (Object)target, (String[])DsmMappingUtils.getNullPropertyNames((Object)src));
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static Map<String, String> asMapOfChanges(DatasourceDetailsUpdate d) {
        HashMap changes = Maps.newHashMap();
        if (d.getContactemail() != null) {
            changes.put("//CONFIGURATION/ADMIN_INFO", XmlEscapers.xmlContentEscaper().escape(d.getContactemail()));
        }
        if (d.getEnglishname() != null) {
            changes.put("//CONFIGURATION/ENGLISH_NAME", XmlEscapers.xmlContentEscaper().escape(d.getEnglishname()));
        }
        if (d.getOfficialname() != null) {
            changes.put("//CONFIGURATION/OFFICIAL_NAME", XmlEscapers.xmlContentEscaper().escape(d.getOfficialname()));
        }
        if (d.getTimezone() != null) {
            changes.put("//CONFIGURATION/LOCATION/TIMEZONE", XmlEscapers.xmlContentEscaper().escape(d.getTimezone()));
        }
        if (d.getLatitude() != null) {
            changes.put("//CONFIGURATION/LOCATION/LATITUDE", XmlEscapers.xmlContentEscaper().escape(String.valueOf(d.getLatitude())));
        }
        if (d.getLongitude() != null) {
            changes.put("//CONFIGURATION/LOCATION/LONGITUDE", XmlEscapers.xmlContentEscaper().escape(String.valueOf(d.getLongitude())));
        }
        if (d.getPlatform() != null) {
            changes.put("//CONFIGURATION/TYPOLOGY", XmlEscapers.xmlContentEscaper().escape(d.getPlatform()));
        }
        if (d.getTypology() != null) {
            changes.put("//CONFIGURATION/DATASOURCE_TYPE", XmlEscapers.xmlContentEscaper().escape(d.getTypology()));
        }
        if (d.getWebsiteurl() != null) {
            changes.put("//CONFIGURATION/REPOSITORY_WEBPAGE", XmlEscapers.xmlContentEscaper().escape(d.getWebsiteurl()));
        }
        return changes;
    }
}

