/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.project;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProjectQueryParams {
    private Pattern patternFundingStream = Pattern.compile("(\\w*(::|%| )*)*");
    private Pattern patternDate = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d");
    private String fundingProgramme = null;
    private String fundingPath = null;
    private String startFrom = null;
    private String startUntil = null;
    private String endFrom = null;
    private String endUntil = null;
    private static final Log log = LogFactory.getLog(ProjectQueryParams.class);

    public String getFundingProgramme() {
        return this.fundingProgramme;
    }

    public void setFundingProgramme(String fundingProgramme) {
        this.fundingProgramme = this.verifyParam(fundingProgramme);
    }

    public String getFundingPath() {
        return this.fundingPath;
    }

    public void setFundingPath(String fundingPath) {
        this.fundingPath = this.verifyParam(fundingPath);
    }

    public String getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(String startFrom) {
        this.startFrom = this.verifyDateParam(startFrom);
    }

    public String getStartUntil() {
        return this.startUntil;
    }

    public void setStartUntil(String startUntil) {
        this.startUntil = this.verifyDateParam(startUntil);
    }

    public String getEndFrom() {
        return this.endFrom;
    }

    public void setEndFrom(String endFrom) {
        this.endFrom = this.verifyDateParam(endFrom);
    }

    public String getEndUntil() {
        return this.endUntil;
    }

    public void setEndUntil(String endUntil) {
        this.endUntil = this.verifyDateParam(endUntil);
    }

    protected String verifyParam(String p) {
        if (p != null && !this.patternFundingStream.matcher(p).matches()) {
            throw new IllegalArgumentException(String.format("Parameter '%s' contains an invalid character", p));
        }
        return p;
    }

    protected String verifyDateParam(String date) {
        if (date != null && !this.patternDate.matcher(date).matches()) {
            throw new IllegalArgumentException(String.format("Parameter date '%s' contains an invalid character. Accepted pattern is %s", date, this.patternDate.toString()));
        }
        return date;
    }
}

