/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.context;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import eu.dnetlib.openaire.context.Category;
import eu.dnetlib.openaire.context.Concept;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.context.Param;
import eu.dnetlib.openaire.funders.domain.FunderDetails;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextMappingUtils {
    private static final List<String> DATE_PATTERN = Lists.newArrayList((Object[])new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm:ssXXX", "yyyy-MM-dd'T'hh:mm:ss+00:00"});

    public static Context parseContext(String s, Queue<Throwable> errors) {
        Document doc;
        SAXReader reader = new SAXReader();
        try {
            doc = reader.read((Reader)new StringReader(s));
        }
        catch (DocumentException e) {
            errors.add(e);
            return new Context();
        }
        try {
            Element eContext = (Element)doc.selectSingleNode("/RESOURCE_PROFILE/BODY/CONFIGURATION/context");
            return new Context().setId(eContext.attributeValue("id")).setLabel(eContext.attributeValue("label")).setType(eContext.attributeValue("type")).setDateofcreation(ContextMappingUtils.asDate((String)doc.valueOf("/RESOURCE_PROFILE/HEADER/DATE_OF_CREATION/@value"))).setParams(ContextMappingUtils.parseParams((Element)eContext)).setCategories(ContextMappingUtils.parseCategories((Element)eContext));
        }
        catch (Throwable e) {
            errors.add(e);
            return new Context();
        }
    }

    private static Date asDate(String s) {
        for (String pattern : DATE_PATTERN) {
            try {
                return DateUtils.parseDate((String)s, (String[])new String[]{pattern});
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    private static Map<String, Category> parseCategories(Element eContext) {
        List eCategory = eContext.selectNodes("//category");
        return eCategory.stream().map(eCat -> new Category().setClaim(ContextMappingUtils.getClaim((Element)eCat).booleanValue()).setId(eCat.attributeValue("id")).setLabel(eCat.attributeValue("label")).setParams(ContextMappingUtils.parseParams((Element)eCat)).setConcepts(ContextMappingUtils.parseConcepts((Element)eCat))).collect(Collectors.toMap(Category::getId, Functions.identity()));
    }

    private static List<Concept> parseConcepts(Element eCategory) {
        List eConcepts = eCategory.selectNodes("./concept");
        return eConcepts.stream().map(eCon -> new Concept().setClaim(ContextMappingUtils.getClaim((Element)eCon).booleanValue()).setId(eCon.attributeValue("id")).setLabel(eCon.attributeValue("label")).setParams(ContextMappingUtils.parseParams((Element)eCon)).setConcepts(ContextMappingUtils.parseConcepts((Element)eCon))).collect(Collectors.toList());
    }

    private static Boolean getClaim(Element eCon) {
        String claim = eCon.attributeValue("claim");
        return BooleanUtils.toBooleanObject((String)(StringUtils.isNotBlank((CharSequence)claim) ? claim : "false"));
    }

    private static Map<String, List<Param>> parseParams(Element e) {
        List params = e.selectNodes("./param");
        return params.stream().map(p -> new Param().setName(p.attributeValue("name")).setValue(p.getTextTrim())).collect(Collectors.toMap(Param::getName, xva$0 -> Lists.newArrayList((Object[])new Param[]{xva$0}), (p1, p2) -> {
            ArrayList p = new ArrayList(p1);
            p.addAll(p2);
            return p;
        }));
    }

    public static FunderDetails asFunderDetails(Context c) {
        return new FunderDetails().setId(c.getId()).setName(c.getLabel()).setShortname(c.getId());
    }
}

