/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.metrics;

import eu.dnetlib.metrics.MetricInterceptor;
import io.prometheus.client.Counter;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestCounterInterceptor
extends HandlerInterceptorAdapter
implements MetricInterceptor {
    private static final Counter requestTotal = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("http_requests_total")).labelNames(new String[]{"method", "handler", "status"})).help("Http Request Total")).register();

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) throws Exception {
        String handlerLabel = handler.toString();
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            handlerLabel = method.getDeclaringClass().getSimpleName() + "." + method.getName();
        }
        ((Counter.Child)requestTotal.labels(new String[]{request.getMethod(), handlerLabel, Integer.toString(response.getStatus())})).inc();
    }
}

