/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.community.CommunityApiCore;
import eu.dnetlib.openaire.community.CommunityContentprovider;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunityProject;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityWritableProperties;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Api(tags={"OpenAIRE Communities API"}, description="the OpenAIRE Community API")
public class CommunityApiController {
    @Autowired
    private CommunityApiCore communityApiCore;

    @RequestMapping(value={"/community/communities"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get all community profiles", notes="get all community profiles", tags={"Community", "Read"}, response=CommunitySummary[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunitySummary[].class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.communityApiCore.listCommunities();
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get community profile", notes="get community profile", tags={"Community", "Read"}, response=CommunityDetails.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityDetails.class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityDetails getCommunity(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunity(id);
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="update community details", notes="update community details", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void setCommunity(@PathVariable String id, @RequestBody CommunityWritableProperties properties) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.setCommunity(id, properties);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get community projects", notes="get community projects", tags={"Community projects", "Read"}, response=CommunityProject[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityProject[].class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunityProject> getCommunityProjects(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityProjects(id);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="associate a project to the community", notes="associate a project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityProject addCommunityProject(@PathVariable String id, @RequestBody CommunityProject project) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityProject(id, project);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ApiOperation(value="remove a project from the community", notes="remove a project from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void deleteCommunityProject(@PathVariable String id, @RequestBody Integer projectId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityProject(id, projectId);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the list of content providers associated to a given community", notes="get the list of content providers associated to a given community", tags={"Community content providers", "Read"}, response=CommunityContentprovider[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityContentprovider[].class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunityContentprovider> getCommunityContentproviders(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityContentproviders(id);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="associate a content provider to the community", notes="associate a content provider to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityContentprovider addCommunityContentprovider(@PathVariable String id, @RequestBody CommunityContentprovider contentprovider) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityContentprovider(id, contentprovider);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ApiOperation(value="remove the association between a content provider and the community", notes="remove the association between a content provider and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void removeCommunityContentprovider(@PathVariable String id, @RequestBody Integer contentproviderId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityContentProvider(id, contentproviderId);
    }

    @RequestMapping(value={"/community/{id}/subjects"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="associate a subject to the community", notes="associate a subject to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityDetails addCommunitySubjects(@PathVariable String id, @RequestBody List<String> subjects) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunitySubjects(id, subjects);
    }

    @RequestMapping(value={"/community/{id}/subjects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ApiOperation(value="remove subjects from a community", notes="remove subjects from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityDetails removeCommunitySubjects(@PathVariable String id, @RequestBody List<String> subjects) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.removeCommunitySubjects(id, subjects);
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the list of Zenodo communities associated to a given community", notes="get the list of Zenodo communities associated to a given community", tags={"Community Zenodo Communities", "Read"}, response=CommunityZenodoCommunity[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityZenodoCommunity[].class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunityZenodoCommunity> getCommunityZenodoCommunities(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityZenodoCommunities(id);
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="associate a Zenodo community to the community", notes="associate a Zenodo community to the community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityZenodoCommunity addCommunityZenodoCommunity(@PathVariable String id, @RequestBody CommunityZenodoCommunity zenodocommunity) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.addCommunityZenodoCommunity(id, zenodocommunity);
    }

    @RequestMapping(value={"/community/{id}/zenodocommunities"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ApiOperation(value="remove a Zenodo community from a community", notes="remove a Zenodo community from a community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void removeCommunityZenodoCOmmunity(@PathVariable String id, @RequestBody Integer zenodoCommId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityZenodoCommunity(id, zenodoCommId);
    }
}

