/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.CommunityConstants;
import eu.dnetlib.openaire.community.CommunityContentprovider;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityMappingUtils;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunityProject;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityWritableProperties;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import eu.dnetlib.openaire.context.Category;
import eu.dnetlib.openaire.context.Concept;
import eu.dnetlib.openaire.context.Context;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
public class CommunityApiCore {
    private static final Log log = LogFactory.getLog(CommunityApiCore.class);
    @Autowired
    private ISClient isClient;

    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.getContextMap().values().stream().filter(context -> !CommunityConstants.communityBlackList.contains(context.getId())).map(CommunityMappingUtils::asCommunitySummary).collect(Collectors.toList());
    }

    public CommunityDetails getCommunity(String id) throws CommunityException, CommunityNotFoundException {
        Context context = (Context)this.getContextMap().get(id);
        if (context == null || CommunityConstants.communityBlackList.contains(id)) {
            throw new CommunityNotFoundException(String.format("community '%s' does not exist", id));
        }
        return CommunityMappingUtils.asCommunityProfile((Context)context);
    }

    public void setCommunity(String id, CommunityWritableProperties details) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        if (details.getShortName() != null) {
            this.isClient.updateContextAttribute(id, "label", details.getShortName());
        }
        if (details.getName() != null) {
            this.isClient.updateContextParam(id, "name", details.getName());
        }
        if (details.getDescription() != null) {
            this.isClient.updateContextParam(id, "description", details.getDescription());
        }
        if (details.getLogoUrl() != null) {
            this.isClient.updateContextParam(id, "logourl", details.getLogoUrl());
        }
        if (details.getStatus() != null) {
            this.isClient.updateContextParam(id, "status", details.getStatus().name());
        }
        if (details.getManagers() != null) {
            this.isClient.updateContextParam(id, "manager", Joiner.on((String)",").join((Iterable)details.getManagers()));
        }
        if (details.getSubjects() != null) {
            this.isClient.updateContextParam(id, "subject", Joiner.on((String)",").join((Iterable)details.getSubjects()));
        }
    }

    public List<CommunityProject> getCommunityProjects(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this._getCommunityInfo(id, "::projects", c -> CommunityMappingUtils.asCommunityProject((String)id, (Concept)c));
    }

    public CommunityProject addCommunityProject(String id, CommunityProject project) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)project.getCommunityId())) {
            throw new CommunityException("parameters 'id' and project.communityId must be coherent");
        }
        TreeMap projects = this.getCommunityProjectMap(id);
        project.setId(this.nextId(projects != null ? (Integer)projects.lastKey() : Integer.valueOf(0)));
        this.isClient.addConcept(id, id + "::projects", CommunityMappingUtils.asProjectXML((String)id, (CommunityProject)project));
        return project;
    }

    private String nextId(Integer id) {
        return String.valueOf(id + 1);
    }

    public void removeCommunityProject(String id, Integer projectId) throws CommunityException, CommunityNotFoundException {
        TreeMap projects = this.getCommunityProjectMap(id);
        if (!projects.containsKey(projectId)) {
            throw new CommunityNotFoundException(String.format("project '%s' doesn't exist within context '%s'", projectId, id));
        }
        this.isClient.removeConcept(id, id + "::projects", id + "::projects" + "::" + projectId);
    }

    public List<CommunityContentprovider> getCommunityContentproviders(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this._getCommunityInfo(id, "::contentproviders", c -> CommunityMappingUtils.asCommunityDataprovider((String)id, (Concept)c));
    }

    public CommunityContentprovider addCommunityContentprovider(String id, CommunityContentprovider cp) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)cp.getCommunityId())) {
            throw new CommunityException("parameters 'id' and cp.communityId must be coherent");
        }
        TreeMap cps = this.getCommunityContentproviderMap(id);
        cp.setId(this.nextId(MapUtils.isNotEmpty((Map)cps) ? (Integer)cps.lastKey() : Integer.valueOf(0)));
        this.isClient.addConcept(id, id + "::contentproviders", CommunityMappingUtils.asContentProviderXML((String)id, (CommunityContentprovider)cp));
        return cp;
    }

    public void removeCommunityContentProvider(String id, Integer contentproviderId) throws CommunityException, CommunityNotFoundException {
        TreeMap providers = this.getCommunityContentproviderMap(id);
        if (!providers.containsKey(contentproviderId)) {
            throw new CommunityNotFoundException(String.format("content provider '%s' doesn't exist within context '%s'", contentproviderId, id));
        }
        this.isClient.removeConcept(id, id + "::contentproviders", id + "::contentproviders" + "::" + contentproviderId);
    }

    public List<CommunityZenodoCommunity> getCommunityZenodoCommunities(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this._getCommunityInfo(id, "::zenodocommunities", c -> CommunityMappingUtils.asCommunityZenodoCommunity((String)id, (Concept)c));
    }

    public CommunityDetails addCommunitySubjects(String id, List<String> subjects) throws CommunityException, CommunityNotFoundException {
        CommunityDetails details = this.getCommunity(id);
        HashSet current = Sets.newHashSet((Iterable)details.getSubjects());
        current.addAll(subjects);
        details.setSubjects((List)Lists.newArrayList((Iterable)current));
        this.setCommunity(id, CommunityWritableProperties.fromDetails((CommunityDetails)details));
        return details;
    }

    public CommunityDetails removeCommunitySubjects(String id, List<String> subjects) throws CommunityException, CommunityNotFoundException {
        CommunityDetails details = this.getCommunity(id);
        HashSet current = Sets.newHashSet((Iterable)details.getSubjects());
        current.removeAll(subjects);
        details.setSubjects((List)Lists.newArrayList((Iterable)current));
        this.setCommunity(id, CommunityWritableProperties.fromDetails((CommunityDetails)details));
        return details;
    }

    public void removeCommunityZenodoCommunity(String id, Integer zenodoCommId) throws CommunityException, CommunityNotFoundException {
        TreeMap zcomms = this.getZenodoCommunityMap(id);
        if (!zcomms.containsKey(zenodoCommId)) {
            throw new CommunityNotFoundException(String.format("Zenodo community '%s' doesn't exist within context '%s'", zenodoCommId, id));
        }
        this.isClient.removeConcept(id, id + "::zenodocommunities", id + "::zenodocommunities" + "::" + zenodoCommId);
    }

    public CommunityZenodoCommunity addCommunityZenodoCommunity(String id, CommunityZenodoCommunity zc) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)zc.getCommunityId())) {
            throw new CommunityException("parameters 'id' and zc.communityId must be coherent");
        }
        if (!StringUtils.isNotBlank((CharSequence)zc.getZenodoid())) {
            throw new CommunityException("parameter zenodoid cannot be null or empty");
        }
        TreeMap zcs = this.getZenodoCommunityMap(id);
        for (CommunityZenodoCommunity czc : zcs.values()) {
            if (!czc.getZenodoid().equals(zc.getZenodoid())) continue;
            throw new CommunityException("Zenodo community already associated to the RCD");
        }
        zc.setId(this.nextId(MapUtils.isNotEmpty((Map)zcs) ? (Integer)zcs.lastKey() : Integer.valueOf(0)));
        this.isClient.addConcept(id, id + "::zenodocommunities", CommunityMappingUtils.asZenodoCommunityXML((String)id, (CommunityZenodoCommunity)zc));
        return zc;
    }

    private TreeMap<Integer, CommunityProject> getCommunityProjectMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityProjects(id).stream().collect(Collectors.toMap(p -> Integer.valueOf(p.getId()), Functions.identity(), (p1, p2) -> {
            log.warn((Object)String.format("duplicate project found: '%s'", p1.getId()));
            return p2;
        }, TreeMap::new));
    }

    private TreeMap<Integer, CommunityContentprovider> getCommunityContentproviderMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityContentproviders(id).stream().collect(Collectors.toMap(cp -> Integer.valueOf(cp.getId()), Functions.identity(), (cp1, cp2) -> {
            log.warn((Object)String.format("duplicate content provider found: '%s'", cp1.getId()));
            return cp2;
        }, TreeMap::new));
    }

    private TreeMap<Integer, CommunityZenodoCommunity> getZenodoCommunityMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityZenodoCommunities(id).stream().collect(Collectors.toMap(cp -> Integer.valueOf(cp.getId()), Functions.identity(), (cp1, cp2) -> {
            log.warn((Object)String.format("duplicate Zenodo community found: '%s'", cp1.getId()));
            return cp2;
        }, TreeMap::new));
    }

    private Map<String, Context> getContextMap() throws CommunityException {
        try {
            return this.isClient.getCommunityContextMap();
        }
        catch (IOException e) {
            throw new CommunityException(e);
        }
    }

    private <R> List<R> _getCommunityInfo(String id, String idSuffix, Function<Concept, R> mapping) throws CommunityException {
        Map categories;
        Category category;
        Map contextMap = this.getContextMap();
        Context context = (Context)contextMap.get(id);
        if (context != null && (category = (Category)(categories = context.getCategories()).get(id + idSuffix)) != null) {
            return category.getConcepts().stream().map(mapping).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

