/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.project.domain.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import java.sql.Date;
import java.util.ArrayList;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="projects_api")
@ApiModel(value="Project api model", description="Project api model used by DSpace and Eprints exporter")
public class ProjectApi {
    public static final String INFO_EU_REPO_GRANT_AGREEMENT = "info:eu-repo/grantAgreement/";
    @Id
    @JsonIgnore
    private String id;
    private String code;
    private String acronym;
    private String title;
    private String funder;
    private String jurisdiction;
    private Date startdate;
    private Date enddate;
    private String fundingpathid;

    public String getIdnamespace() {
        String res = INFO_EU_REPO_GRANT_AGREEMENT + this.getFunder() + "/";
        String fundingProgram = this.asFundingProgram(this.getFundingpathid());
        if (StringUtils.isNotBlank((CharSequence)fundingProgram)) {
            res = res + fundingProgram;
        }
        res = res + "/" + this.escapeCode(this.getCode());
        if (StringUtils.isNotBlank((CharSequence)this.getJurisdiction())) {
            res = res + "/" + this.getJurisdiction();
        }
        return res;
    }

    public String getListLabel() {
        return String.format("for:value:component:_%s_project_id", this.asFunder(this.getFunder()));
    }

    private String asFunder(String legalshortname) {
        switch (legalshortname.toLowerCase()) {
            case "ec": {
                return this.asFundingProgram(this.getFundingpathid()).toLowerCase();
            }
        }
        return legalshortname.toLowerCase();
    }

    private String escapeCode(String code) {
        return this.replaceSlash(code);
    }

    private String asFundingProgram(String fundingpathid) {
        ArrayList strings = Lists.newArrayList((Iterable)Splitter.on((String)"::").split((CharSequence)fundingpathid));
        if (strings.size() <= 1) {
            throw new IllegalStateException("Unexpected funding id: " + fundingpathid);
        }
        if (strings.size() == 2) {
            return "";
        }
        return this.replaceSlash((String)strings.get(2));
    }

    private String replaceSlash(String s) {
        return s.replaceAll("/", "%2F");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFunder() {
        return this.funder;
    }

    public void setFunder(String funder) {
        this.funder = funder;
    }

    public String getJurisdiction() {
        return this.jurisdiction;
    }

    public void setJurisdiction(String jurisdiction) {
        this.jurisdiction = jurisdiction;
    }

    public Date getStartdate() {
        return this.startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
    }

    public Date getEnddate() {
        return this.enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
    }

    public String getFundingpathid() {
        return this.fundingpathid;
    }

    public void setFundingpathid(String fundingpathid) {
        this.fundingpathid = fundingpathid;
    }
}

