/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.metrics;

import eu.dnetlib.metrics.MetricInterceptor;
import io.prometheus.client.Summary;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class RequestTimingInterceptor
extends HandlerInterceptorAdapter
implements MetricInterceptor {
    private static final String REQ_PARAM_TIMING = "timing";
    private static final Summary responseTimeInMs = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("http_response_time_milliseconds")).labelNames(new String[]{"method", "handler", "status"})).help("Request completed time in milliseconds")).register();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute(REQ_PARAM_TIMING, (Object)System.currentTimeMillis());
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Long timingAttr = (Long)request.getAttribute(REQ_PARAM_TIMING);
        long completedTime = System.currentTimeMillis() - timingAttr;
        String handlerLabel = handler.toString();
        if (handler instanceof HandlerMethod) {
            Method method = ((HandlerMethod)handler).getMethod();
            handlerLabel = method.getDeclaringClass().getSimpleName() + "." + method.getName();
        }
        ((Summary.Child)responseTimeInMs.labels(new String[]{request.getMethod(), handlerLabel, Integer.toString(response.getStatus())})).observe((double)completedTime);
    }
}

