package eu.dnetlib.openaire.community;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
public class CommunityDetails extends CommunitySummary {

	@ApiModelProperty("date of creation for this community")
	private Date creationDate;

	@ApiModelProperty("list of subjects (keywords) that characterise this community")
	private List<String> subjects;

	public CommunityDetails() {
	}

	public CommunityDetails(final CommunitySummary summary) {
		super(summary);
	}

	public Date getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(final Date creationDate) {
		this.creationDate = creationDate;
	}

	public List<String> getSubjects() {
		return subjects;
	}

	public void setSubjects(final List<String> subjects) {
		this.subjects = subjects;
	}
}
