/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm;

import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.common.OperationManager;
import eu.dnetlib.openaire.dsm.DsmCore;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.ApiDetailsResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.dsm.domain.DatasourceResponse;
import eu.dnetlib.openaire.dsm.domain.FilterName;
import eu.dnetlib.openaire.dsm.domain.RequestFilter;
import eu.dnetlib.openaire.dsm.domain.RequestSort;
import eu.dnetlib.openaire.dsm.domain.RequestSortOrder;
import eu.dnetlib.openaire.dsm.domain.Response;
import eu.dnetlib.openaire.vocabularies.Country;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
@Api(tags={"OpenAIRE DSM API"}, description="the OpenAIRE Datasource Manager API")
public class DsmApiController
extends AbstractExporterController {
    @Autowired
    private DsmCore dsmCore;
    @Autowired
    private OperationManager operationManager;

    @RequestMapping(value={"/ds/countries"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="list the datasource countries", notes="list the datasource countries", tags={"Datasource", "Read"}, response=Country[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Country[].class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public List<Country> listCountries() throws DsmException {
        return this.dsmCore.listCountries();
    }

    @RequestMapping(value={"/ds/search/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="search datasources", notes="Returns list of Datasource details.", tags={"Datasource", "Read"}, response=DatasourceResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public DatasourceResponse search(@RequestParam RequestSort requestSortBy, @RequestParam RequestSortOrder order, @RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        DatasourceResponse rsp = this.dsmCore.search(requestSortBy, order, requestFilter, page, size);
        return (DatasourceResponse)this.prepareResponse(page, size, stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/searchsnippet/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="search datasources", notes="Returns list of Datasource basic info.", tags={"Datasource", "Read"}, response=DatasourceResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public DatasourceResponse searchSnippet(@RequestParam RequestSort requestSortBy, @RequestParam RequestSortOrder order, @RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        DatasourceResponse rsp = this.dsmCore.searchSnippet(requestSortBy, order, requestFilter, page, size);
        return (DatasourceResponse)this.prepareResponse(page, size, stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/api/{dsId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the list of API for a given datasource", notes="Returns the list of API for a given datasource.", tags={"Interface", "Read"}, response=ApiDetailsResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ApiDetailsResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public ApiDetailsResponse getApi(@PathVariable String dsId) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        ApiDetailsResponse rsp = this.dsmCore.getApis(dsId);
        return (ApiDetailsResponse)this.prepareResponse(0, rsp.getApi().size(), stop, (Response)rsp);
    }

    @RequestMapping(value={"/api/baseurl/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="search for the list of base URLs of Datasource APIs managed by a user", notes="Returns the list of base URLs of Datasource APIs managed by a user", tags={"Datasource", "Interface", "Read"}, response=String[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String[].class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public List<String> searchBaseUrls(@RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        return this.dsmCore.findBaseURLs(requestFilter, page, size);
    }

    @RequestMapping(value={"/ds/api/{apiId}"}, method={RequestMethod.DELETE})
    @ApiOperation(value="delete an API", notes="delete an API, if removable", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=403, message="Api not removable", response=AbstractExporterController.ErrorMessage.class)})
    public void deleteApi(@PathVariable String apiId) throws DsmException, DsmForbiddenException {
        this.dsmCore.deleteApi(apiId);
    }

    @RequestMapping(value={"/ds/manage"}, method={RequestMethod.POST})
    @ApiOperation(value="set the managed status for a given datasource", notes="set the managed status for a given datasource", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void setManaged(@RequestParam String id, @RequestParam boolean managed) throws DsmException {
        this.dsmCore.setManaged(id, managed);
    }

    @RequestMapping(value={"/ds/managed/{dsId}"}, method={RequestMethod.GET})
    @ApiOperation(value="get the datasource managed status", notes="get the datasource managed status", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public boolean isManaged(@PathVariable String id) throws DsmException {
        return this.dsmCore.isManaged(id);
    }

    @RequestMapping(value={"/ds/add"}, method={RequestMethod.POST})
    @ApiOperation(value="add a new Datasource", notes="add a new Datasource", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Malformed request", response=AbstractExporterController.ErrorMessage[].class), @ApiResponse(code=500, message="Unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void saveDs(@Valid @RequestBody DatasourceDetails datasource) throws DsmException {
        if (this.dsmCore.exist(datasource)) {
            throw new DsmException(409, String.format("cannot register, datasource already defined '%s'", datasource.getId()));
        }
        this.dsmCore.save(datasource);
    }

    @RequestMapping(value={"/ds/update"}, method={RequestMethod.POST})
    @ApiOperation(value="update Datasource details", notes="update Datasource details", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateDatasource(@RequestBody DatasourceDetailsUpdate ds) throws DsmException, DsmNotFoundException {
        this.dsmCore.updateDatasource(ds);
    }

    @Deprecated
    @RequestMapping(value={"/ds/logourl"}, method={RequestMethod.POST})
    @ApiOperation(value="update a datasource name", notes="update a datasource name", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateDatasourceLogoURL(@RequestParam String dsId, @RequestParam String logourl) throws DsmException {
        this.dsmCore.updateDatasourceLogoUrl(dsId, logourl);
    }

    @Deprecated
    @RequestMapping(value={"/ds/name"}, method={RequestMethod.POST})
    @ApiOperation(value="update a datasource name", notes="update a datasource name", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateDatasourceName(@RequestParam String dsId, @RequestParam String officialname, @RequestParam String englishname) throws DsmException {
        this.dsmCore.updateDatasourcename(dsId, officialname, englishname);
    }

    @Deprecated
    @RequestMapping(value={"/ds/coordinates"}, method={RequestMethod.POST})
    @ApiOperation(value="update the datasource coordinates (latitude, longitude)", notes="update the datasource coordinates (latitude, longitude)", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateCoordinates(@RequestParam String dsId, @RequestParam Double latitude, @RequestParam Double longitude) throws DsmException {
        this.dsmCore.updateCoordinates(dsId, latitude, longitude);
    }

    @Deprecated
    @RequestMapping(value={"/ds/timezone"}, method={RequestMethod.POST})
    @ApiOperation(value="update a datasource timezone", notes="update a datasource timezone", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateTimezone(@RequestParam String dsId, @RequestParam String timezone) throws DsmException {
        this.dsmCore.updateTimezone(dsId, timezone);
    }

    @Deprecated
    @RequestMapping(value={"/ds/typology"}, method={RequestMethod.POST})
    @ApiOperation(value="update a datasource typology code", notes="update a datasource typology code", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateTypology(@RequestParam String dsId, @RequestParam String typology) throws DsmException {
        this.dsmCore.updateDsTypology(dsId, typology);
    }

    @Deprecated
    @RequestMapping(value={"/ds/registeredby"}, method={RequestMethod.POST})
    @ApiOperation(value="update a datasource registeredBy", notes="update a datasource registeredBy", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateRegisteringUser(@RequestParam String dsId, @RequestParam String registeredBy) throws DsmException {
        this.dsmCore.updateDsRegisteringUser(dsId, registeredBy);
    }

    @Deprecated
    @RequestMapping(value={"/ds/platform"}, method={RequestMethod.POST})
    @ApiOperation(value="update a datasource platform", notes="update a datasource platform", tags={"Datasource", "Write", "Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updatePlatform(@RequestParam String dsId, @RequestParam String platform) throws DsmException {
        this.dsmCore.updateDsPlatform(dsId, platform);
    }

    @RequestMapping(value={"/ds/api/baseurl"}, method={RequestMethod.POST})
    @ApiOperation(value="update the base URL of a datasource interface", notes="update the base URL of a datasource interface", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateBaseUrl(@RequestParam String dsId, @RequestParam String apiId, @RequestParam String baseUrl) throws DsmException {
        this.dsmCore.updateApiBaseurl(dsId, apiId, baseUrl);
    }

    @RequestMapping(value={"/ds/api/compliance"}, method={RequestMethod.POST})
    @ApiOperation(value="update the compatibility of a datasource interface", notes="update the compatibility of a datasource interface", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateCompliance(@RequestParam String dsId, @RequestParam String apiId, @RequestParam String compliance, @RequestParam(required=false, defaultValue="false") boolean override) throws DsmException {
        this.dsmCore.updateApiCompatibility(dsId, apiId, compliance, override);
    }

    @RequestMapping(value={"/ds/api/oaiset"}, method={RequestMethod.POST})
    @ApiOperation(value="update the OAI set of a datasource interface", notes="update the OAI set of a datasource interface", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void updateOaiSetl(@RequestParam String dsId, @RequestParam String apiId, @RequestParam String oaiSet) throws DsmException {
        this.dsmCore.updateApiOaiSet(dsId, apiId, oaiSet);
    }

    @RequestMapping(value={"/ds/api/add"}, method={RequestMethod.POST})
    @ApiOperation(value="adds a new Interface to one Datasource", notes="adds an Interface to one Datasource", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void addApi(@RequestBody ApiDetails api) throws DsmException {
        if (StringUtils.isBlank((CharSequence)api.getDatasource())) {
            throw new DsmException(400, "missing datasource id");
        }
        this.dsmCore.addApi(api);
    }

    @RequestMapping(value={"/dsm/ops"}, method={RequestMethod.GET})
    @ApiOperation(value="get the number of pending operations", notes="get the number of pending operations", tags={"Read", "Management"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public int getOps() throws DsmException {
        return this.operationManager.getOpSize();
    }

    @RequestMapping(value={"/dsm/killops"}, method={RequestMethod.POST})
    @ApiOperation(value="interrupts the pending operations", notes="return the number of interrupted operations", tags={"Write", "Management"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public int killOps() throws DsmException {
        return this.operationManager.dropAll();
    }

    @RequestMapping(value={"/dsm/dropcache"}, method={RequestMethod.POST})
    @ApiOperation(value="drop the caches", notes="drop the internal caches", tags={"Write", "Management"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public void dropCache() throws DsmException {
        this.dsmCore.dropCaches();
    }

    @Deprecated
    @ApiOperation(value="search datasources by name", notes="Returns list of Datasource details.", tags={"Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    @RequestMapping(value={"/ds/search/name/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    DatasourceResponse searchByName(String name, int page, int size) throws DsmException {
        RequestSort sort = RequestSort.id;
        RequestSortOrder order = RequestSortOrder.ASCENDING;
        RequestFilter filter = new RequestFilter();
        filter.put((Object)FilterName.englishname, (Object)name);
        return this.dsmCore.search(sort, order, filter, page, size);
    }

    @Deprecated
    @ApiOperation(value="search datasources by contact email", notes="Returns list of Datasource details.", tags={"Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    @RequestMapping(value={"/ds/search/email/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    DatasourceResponse searchByContactemail(String contactemail, int page, int size) throws DsmException {
        RequestSort sort = RequestSort.id;
        RequestSortOrder order = RequestSortOrder.ASCENDING;
        RequestFilter filter = new RequestFilter();
        filter.put((Object)FilterName.contactemail, (Object)contactemail);
        return this.dsmCore.search(sort, order, filter, page, size);
    }

    @Deprecated
    @ApiOperation(value="search datasources by country", notes="Returns list of Datasource details.", tags={"Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    @RequestMapping(value={"/ds/search/country/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    DatasourceResponse searchByCountry(String country, Boolean managed, int page, int size) throws DsmException {
        RequestSort sort = RequestSort.id;
        RequestSortOrder order = RequestSortOrder.ASCENDING;
        RequestFilter filter = new RequestFilter();
        filter.put((Object)FilterName.country, (Object)country);
        filter.put((Object)FilterName.managed, (Object)managed);
        return this.dsmCore.search(sort, order, filter, page, size);
    }

    @Deprecated
    @ApiOperation(value="search datasources by registering user", notes="Returns list of Datasource details.", tags={"Deprecated"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    @RequestMapping(value={"/ds/search/registeredby/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    DatasourceResponse searchByRegisteringUser(String registeredBy, int page, int size) throws DsmException {
        RequestSort sort = RequestSort.id;
        RequestSortOrder order = RequestSortOrder.ASCENDING;
        RequestFilter filter = new RequestFilter();
        filter.put((Object)FilterName.registeredby, (Object)registeredBy);
        return this.dsmCore.search(sort, order, filter, page, size);
    }

    private <T extends Response> T prepareResponse(int page, int size, StopWatch stop, Response rsp) {
        rsp.getHeader().setTime(stop.getTime()).setPage(page).setSize(size);
        return (T)rsp;
    }
}

