package eu.dnetlib;

import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.stereotype.Component;

import static java.util.Arrays.asList;

@Component
public class CacheCustomizer implements CacheManagerCustomizer<ConcurrentMapCacheManager> {

    @Override
    public void customize(final ConcurrentMapCacheManager cacheManager) {
        cacheManager.setCacheNames(
                asList(
                        "fundingpath-ids",
                        "indexdsinfo-cache",
                        "objectstoreid-cache",
                        "context-cache",
                        "dsm-aggregationhistory-cache",
                        "dsm-firstharvestdate-cache",
                        "vocabularies-cache",
                        "community-cache"));
    }


}