package eu.dnetlib.openaire.community;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
public class CommunitySummary {

	@ApiModelProperty("identifies the community")
	protected String id;

	@ApiModelProperty("values for this field reflect the index field _community_ in the index, e.g. 'egi||EGI Federation'")
	protected String queryId;

	@ApiModelProperty("community type")
	protected String type;

	@ApiModelProperty("community name")
	protected String name;

	@ApiModelProperty("community short name")
	protected String shortName;

	@ApiModelProperty("community creation date")
	protected Date creationDate;

	@ApiModelProperty("community last update date")
	protected Date lastUpdateDate;

	@ApiModelProperty("community description")
	protected String description;

	@ApiModelProperty("list of community manager emails")
	protected List<String> managers;

	@ApiModelProperty("http url for the community logo")
	protected String logoUrl;

	@ApiModelProperty("status of the community, drives its visibility")
	protected CommunityStatus status;

	@ApiModelProperty("Zenodo community associated to this community")
	protected String zenodoCommunity;

	public CommunitySummary() {
	}

	public CommunitySummary(
			final String id,
			final String queryId,
			final String type,
			final String name,
			final String shortName,
			final Date creationDate,
			final Date lastUpdateDate,
			final String description,
			final List<String> managers,
			final String logoUrl,
			final CommunityStatus status,
			final String zenodoCommunity) {
		this.id = id;
		this.queryId = queryId;
		this.type = type;
		this.name = name;
		this.shortName = shortName;
		this.creationDate = creationDate;
		this.lastUpdateDate = lastUpdateDate;
		this.description = description;
		this.managers = managers;
		this.logoUrl = logoUrl;
		this.status = status;
		this.zenodoCommunity = zenodoCommunity;
	}

	public CommunitySummary(final CommunitySummary summary) {
		this(summary.getId(),
				summary.getQueryId(),
				summary.getType(),
				summary.getName(),
				summary.getShortName(),
				summary.getCreationDate(),
				summary.getLastUpdateDate(),
				summary.getDescription(),
				summary.getManagers(),
				summary.getLogoUrl(),
				summary.getStatus(),
				summary.getZenodoCommunity());
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getQueryId() {
		return queryId;
	}

	public void setQueryId(final String queryId) {
		this.queryId = queryId;
	}

	public String getType() {
		return type;
	}

	public void setType(final String type) {
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(final String shortName) {
		this.shortName = shortName;
	}

	public Date getCreationDate() {  return creationDate; }

	public void setCreationDate(final Date creationDate) { this.creationDate = creationDate; }

	public Date getLastUpdateDate() { return lastUpdateDate; }

	public void setLastUpdateDate(final Date lastUpdateDate) { this.lastUpdateDate = lastUpdateDate; }

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public List<String> getManagers() {
		return managers;
	}

	public void setManagers(final List<String> managers) {
		this.managers = managers;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public void setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
	}

	public CommunityStatus getStatus() {
		return status;
	}

	public void setStatus(final CommunityStatus status) {
		this.status = status;
	}

	public String getZenodoCommunity() {
		return zenodoCommunity;
	}

	public void setZenodoCommunity(String zenodoCommunity) {
		this.zenodoCommunity = zenodoCommunity;
	}

}
