package eu.dnetlib.openaire.community;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
public class CommunityWritableProperties {

	@ApiModelProperty("community name")
	private String name;

	@ApiModelProperty("community short name")
	private String shortName;

	@ApiModelProperty("community description")
	private String description;

	@ApiModelProperty("http url for the community logo")
	private String logoUrl;

	@ApiModelProperty("list of community manager emails")
	private List<String> managers;

	@ApiModelProperty("list of subjects (keywords) that characterise this community")
	private List<String> subjects;

	@ApiModelProperty("status of the community, drives its visibility")
	private CommunityStatus status;


	public static CommunityWritableProperties fromDetails(final CommunityDetails details) {
		CommunityWritableProperties p = new CommunityWritableProperties();
		p.setName(details.getName());
		p.setShortName(details.getShortName());
		p.setDescription(details.getDescription());
		p.setLogoUrl(details.getLogoUrl());
		p.setManagers(details.getManagers());
		p.setSubjects(details.getSubjects());
		p.setStatus(details.getStatus());
		return p;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(final String shortName) {
		this.shortName = shortName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public List<String> getManagers() {
		return managers;
	}

	public void setManagers(final List<String> managers) {
		this.managers = managers;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public void setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
	}

	public List<String> getSubjects() {
		return subjects;
	}

	public void setSubjects(final List<String> subjects) {
		this.subjects = subjects;
	}

	public CommunityStatus getStatus() {
		return status;
	}

	public void setStatus(final CommunityStatus status) {
		this.status = status;
	}

}
