package eu.dnetlib.openaire.dsm.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

@JsonAutoDetect
@ApiModel(value = "Datasource model", description = "provides information about the datasource")
public class DatasourceSnippet {

    @NotBlank
    @ApiModelProperty(position = 0)
    private String id;

    @NotBlank
    @Length(max = 300)
    @ApiModelProperty(position = 2)
    private String officialname;

    @NotBlank
    @Length(max = 300)
    @ApiModelProperty(position = 3)
    private String englishname;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOfficialname() {
        return officialname;
    }

    public void setOfficialname(String officialname) {
        this.officialname = officialname;
    }

    public String getEnglishname() {
        return englishname;
    }

    public void setEnglishname(String englishname) {
        this.englishname = englishname;
    }
}
