package eu.dnetlib.openaire.community;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.util.*;

@Component
public class CommunityClientImpl implements CommunityClient {

    private static final Log log = LogFactory.getLog(CommunityClient.class);

//    @Autowired
//    private CommunityApiCore communityApiCore;

    @Autowired
    private CommunityCommon communityCommon;

//    final Map<String, Set<String>> inverseListMap = new HashMap<>();

    @Override
    @Cacheable("community-cache")
    public Map<String, Set<String>> getInverseZenodoCommunityMap () {
        log.info("Creating the data structure. Not using cache");
        final Map<String, Set<String>> inverseListMap = new HashMap<>();

        try {
           final List<CommunitySummary> communityList = communityCommon.listCommunities();

            for(CommunitySummary cs :communityList){
                final String communityId =  cs.getId();
                List<CommunityZenodoCommunity> czc = communityCommon.getCommunityZenodoCommunities(communityId);
                for(CommunityZenodoCommunity zc:czc){
                    final String zenodoId = zc.getZenodoid();
                    if(!inverseListMap.containsKey(zenodoId)) {
                        inverseListMap.put(zc.getZenodoid(),new HashSet<>());
                    }
                    inverseListMap.get(zc.getZenodoid()).add(cs.getId());
                }

            }
        } catch (CommunityException e) {
            e.printStackTrace();
        } catch (CommunityNotFoundException e) {
            e.printStackTrace();
        }
        return inverseListMap;
    }

    @Override
    @CacheEvict(value="community-cache",allEntries = true)
    public void dropCache(){
        log.info("dropping cache");
    }


}
