/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import com.google.common.collect.Lists;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.CommunityConstants;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityMappingUtils;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import eu.dnetlib.openaire.context.Category;
import eu.dnetlib.openaire.context.Concept;
import eu.dnetlib.openaire.context.Context;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommunityCommon {
    @Autowired
    private ISClient isClient;

    public Map<String, Context> getContextMap() throws CommunityException {
        try {
            return this.isClient.getCommunityContextMap();
        }
        catch (IOException e) {
            throw new CommunityException(e);
        }
    }

    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.getContextMap().values().stream().filter(context -> !CommunityConstants.communityBlackList.contains(context.getId())).map(CommunityMappingUtils::asCommunitySummary).collect(Collectors.toList());
    }

    public <R> List<R> getCommunityInfo(String id, String idSuffix, Function<Concept, R> mapping) throws CommunityException {
        Map categories;
        Category category;
        Map contextMap = this.getContextMap();
        Context context = (Context)contextMap.get(id);
        if (context != null && (category = (Category)(categories = context.getCategories()).get(id + idSuffix)) != null) {
            return category.getConcepts().stream().map(mapping).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    public CommunityDetails getCommunity(String id) throws CommunityException, CommunityNotFoundException {
        Context context = (Context)this.getContextMap().get(id);
        if (context == null || CommunityConstants.communityBlackList.contains(id)) {
            throw new CommunityNotFoundException(String.format("community '%s' does not exist", id));
        }
        return CommunityMappingUtils.asCommunityProfile((Context)context);
    }

    public List<CommunityZenodoCommunity> getCommunityZenodoCommunities(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this.getCommunityInfo(id, "::zenodocommunities", c -> CommunityMappingUtils.asCommunityZenodoCommunity((String)id, (Concept)c));
    }
}

