package eu.dnetlib.openaire.community;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.gson.Gson;
import eu.dnetlib.openaire.community.selectioncriteria.SelectionCriteria;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsonAutoDetect
public class CommunityContentprovider {

	private static final Log log = LogFactory.getLog(CommunityContentprovider.class);

	@ApiModelProperty(value = "OpenAIRE identifier for this content provider, if available", required = false)
	private String openaireId;

	@NotNull
	@ApiModelProperty(value = "the community identifier this content provider belongs to", required = true)
	private String communityId;

	@NotNull
	@ApiModelProperty(value = "identifies this content provider within the context it belongs to", required = true)
	private String id;

	@ApiModelProperty(value = "content provider name", required = false)
	private String name;

	@NotNull
	@ApiModelProperty(value = "content provider official name", required = true)
	private String officialname;

	//@NotNull
	@ApiModelProperty(value = "content provider selection criteria", required = false)
	private SelectionCriteria selectioncriteria;

	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public String getCommunityId() {
		return communityId;
	}

	public void setCommunityId(final String communityId) {
		this.communityId = communityId;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getOfficialname() {
		return officialname;
	}

	public void setOfficialname(final String officialname) {
		this.officialname = officialname;
	}

	public SelectionCriteria getSelectioncriteria() {
		log.info("Returned selection criteria " + toJson());
		return  this.selectioncriteria;
	}

	public void setSelectioncriteria(SelectionCriteria selectioncriteria) {
		this.selectioncriteria = selectioncriteria;
		log.info("Setted selection criteria " + this.selectioncriteria);
	}

	public String toString(){
		return String.format("id %s, name %s, selection criteria %s" , this.id, this.name, toJson());
	}


	public String toJson() {
		if (selectioncriteria == null)
			return "";
		return new Gson().toJson(selectioncriteria);
	}

	public String toXML() {
		if (selectioncriteria == null)
			return "";
		return "<![CDATA["+ toJson() + "]]>";
	}
}
