/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.community.CommunityClient;
import eu.dnetlib.openaire.community.CommunityCommon;
import eu.dnetlib.openaire.community.CommunityException;
import eu.dnetlib.openaire.community.CommunityNotFoundException;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class CommunityClientImpl
implements CommunityClient {
    private static final Log log = LogFactory.getLog(CommunityClient.class);
    @Autowired
    private CommunityCommon communityCommon;

    @Cacheable(value={"community-cache"})
    public Map<String, Set<String>> getInverseZenodoCommunityMap() {
        log.info((Object)"Creating the data structure. Not using cache");
        HashMap<String, Set<String>> inverseListMap = new HashMap<String, Set<String>>();
        try {
            List communityList = this.communityCommon.listCommunities();
            for (CommunitySummary cs : communityList) {
                String communityId = cs.getId();
                List czc = this.communityCommon.getCommunityZenodoCommunities(communityId);
                for (CommunityZenodoCommunity zc : czc) {
                    String zenodoId = zc.getZenodoid();
                    if (!inverseListMap.containsKey(zenodoId)) {
                        inverseListMap.put(zc.getZenodoid(), new HashSet());
                    }
                    ((Set)inverseListMap.get(zc.getZenodoid())).add(cs.getId());
                }
            }
        }
        catch (CommunityException e) {
            e.printStackTrace();
        }
        catch (CommunityNotFoundException e) {
            e.printStackTrace();
        }
        return inverseListMap;
    }

    @CacheEvict(value={"community-cache"}, allEntries=true)
    public void dropCache() {
        log.info((Object)"dropping cache");
    }
}

