/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.datasources.common.AggregationInfo;
import eu.dnetlib.enabling.datasources.common.AggregationStage;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.CommunityClient;
import eu.dnetlib.openaire.dsm.dao.DatasourceDao;
import eu.dnetlib.openaire.dsm.dao.DatasourceIndexClient;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClient;
import eu.dnetlib.openaire.dsm.dao.ObjectStoreClient;
import eu.dnetlib.openaire.dsm.dao.ResponseUtils;
import eu.dnetlib.openaire.dsm.dao.VocabularyClient;
import eu.dnetlib.openaire.dsm.dao.utils.DsmMappingUtils;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.ApiDetailsResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.dsm.domain.DatasourceInfo;
import eu.dnetlib.openaire.dsm.domain.DatasourceResponse;
import eu.dnetlib.openaire.dsm.domain.RequestFilter;
import eu.dnetlib.openaire.dsm.domain.RequestSort;
import eu.dnetlib.openaire.dsm.domain.RequestSortOrder;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceDbEntry;
import eu.dnetlib.openaire.vocabularies.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class DsmCore {
    private static final Log log = LogFactory.getLog(DsmCore.class);
    @Autowired
    private MongoLoggerClient mongoLoggerClient;
    @Autowired
    private ISClient isClient;
    @Autowired
    private ObjectStoreClient objectStoreClient;
    @Autowired
    private DatasourceIndexClient datasourceIndexClient;
    @Autowired
    private VocabularyClient vocabularyClient;
    @Autowired
    private DatasourceDao dsDao;
    @Autowired
    private OpenaireExporterConfig config;
    @Autowired
    private CommunityClient communityClient;
    private ListeningExecutorService executor;

    @PostConstruct
    public void init() {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(this.config.getRequestWorkers(), new ThreadFactoryBuilder().setNameFormat("dsm-client-%d").build()));
    }

    public List<Country> listCountries() throws DsmException {
        try {
            return this.dsDao.listCountries();
        }
        catch (Throwable e) {
            log.error((Object)"error listing countries", e);
            throw e;
        }
    }

    public DatasourceResponse search(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            ArrayList datasourceInfo = Lists.newArrayList();
            LinkedBlockingQueue errors = Queues.newLinkedBlockingQueue();
            CountDownLatch outerLatch = new CountDownLatch(2);
            Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
            if (dsPage.getTotalElements() > 0L && dsPage.getNumberOfElements() > 0) {
                dsPage.forEach(d -> datasourceInfo.add(this.enrichDatasourceInfo(DsmMappingUtils.asDetails((DatasourceDbEntry)d), outerLatch, errors)));
                this.waitLatch(outerLatch, (Queue)errors, this.config.getRequestTimeout());
            }
            if (!errors.isEmpty()) {
                errors.forEach(e -> log.error(e));
            }
            return ResponseUtils.datasourceResponse((List)datasourceInfo, (Queue)errors, (long)dsPage.getTotalElements());
        }
        catch (Throwable e2) {
            log.error((Object)"error searching datasources", e2);
            throw e2;
        }
    }

    public DatasourceResponse searchSnippet(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.datasourceResponse((List)dsPage.map(d -> DsmMappingUtils.asSnippet((DatasourceDbEntry)d)).getContent(), (Queue)Queues.newLinkedBlockingQueue(), (long)dsPage.getTotalElements());
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasources", e);
            throw e;
        }
    }

    public List<String> findBaseURLs(RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            return this.dsDao.findApiBaseURLs(requestFilter, page, size);
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasource base urls", e);
            throw e;
        }
    }

    public ApiDetailsResponse getApis(String dsId) throws DsmException {
        try {
            List apis = this.dsDao.getApis(dsId);
            List api = apis.stream().map(DsmMappingUtils::asDetails).collect(Collectors.toList());
            return ResponseUtils.apiResponse(api, (long)api.size());
        }
        catch (Throwable e) {
            log.error((Object)String.format("error searching datasource api %s", dsId), e);
            throw e;
        }
    }

    public void setManaged(String dsId, boolean managed) throws DsmException {
        log.info((Object)String.format("updated api '%s' managed with '%s'", dsId, managed));
        this.dsDao.setManaged(dsId, managed);
    }

    public boolean isManaged(String dsId) throws DsmException {
        return this.dsDao.isManaged(dsId);
    }

    public boolean exist(DatasourceDetails d) throws DsmException {
        return this.dsDao.existDs(d.getId());
    }

    public void save(DatasourceDetails d) throws DsmException {
        try {
            this.dsDao.saveDs((Datasource)DsmMappingUtils.asDbEntry((DatasourceDetails)d));
            this.isClient.registerDS(d);
        }
        catch (Throwable e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    public void updateDatasource(DatasourceDetailsUpdate d) throws DsmException, DsmNotFoundException {
        try {
            Datasource ds = this.dsDao.getDs(d.getId());
            DatasourceDbEntry dbEntry = (DatasourceDbEntry)ds;
            if (dbEntry == null) {
                throw new DsmNotFoundException(String.format("ds '%s' does not exist", d.getId()));
            }
            DatasourceDbEntry update = DsmMappingUtils.asDbEntry((DatasourceDetailsUpdate)d);
            if (d.getIdentities() != null) {
                HashSet identities = new HashSet(Stream.of(update.getIdentities(), dbEntry.getIdentities()).flatMap(Collection::stream).collect(Collectors.toMap(i -> i.getIssuertype() + i.getPid(), Function.identity(), (i1, i2) -> i1)).values());
                DsmMappingUtils.copyNonNullProperties((Object)update, (Object)dbEntry);
                dbEntry.setIdentities(identities);
            } else {
                DsmMappingUtils.copyNonNullProperties((Object)update, (Object)dbEntry);
            }
            this.dsDao.saveDs((Datasource)dbEntry);
            this.isClient.updateDatasourceFields(d.getId(), DsmMappingUtils.asMapOfChanges((DatasourceDetailsUpdate)d));
        }
        catch (Throwable e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    @Deprecated
    public void updateDatasourcename(String dsId, String officialname, String englishname) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' with officialname '%s' and englishname '%s'", dsId, officialname, englishname));
        this.dsDao.updateName(dsId, officialname, englishname);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/OFFICIAL_NAME", XmlEscapers.xmlContentEscaper().escape(officialname));
        changes.put("//CONFIGURATION/ENGLISH_NAME", XmlEscapers.xmlContentEscaper().escape(englishname));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    @Deprecated
    public void updateDatasourceLogoUrl(String dsId, String logourl) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' with logo URL '%s'", dsId, logourl));
        this.dsDao.updateLogoUrl(dsId, logourl);
    }

    @Deprecated
    public void updateCoordinates(String dsId, Double latitude, Double longitude) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' with coordinates Lat:'%s', Lon:'%s'", dsId, latitude, longitude));
        this.dsDao.updateCoordinates(dsId, latitude, longitude);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/LOCATION/LATITUDE", XmlEscapers.xmlContentEscaper().escape(String.valueOf(latitude)));
        changes.put("//CONFIGURATION/LOCATION/LONGITUDE", XmlEscapers.xmlContentEscaper().escape(String.valueOf(longitude)));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    @Deprecated
    public void updateTimezone(String dsId, String timezone) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' timezone with '%s'", dsId, timezone));
        this.dsDao.updateTimezone(dsId, timezone);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/LOCATION/TIMEZONE", XmlEscapers.xmlContentEscaper().escape(timezone));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    @Deprecated
    public void updateDsTypology(String dsId, String typology) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' typology with '%s'", dsId, typology));
        this.dsDao.updateTypology(dsId, typology);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/DATASOURCE_TYPE", XmlEscapers.xmlContentEscaper().escape(typology));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    @Deprecated
    public void updateDsRegisteringUser(String dsId, String registeredBy) throws DsmException {
        log.info((Object)String.format("setting datasource '%s' registering user with '%s'", dsId, registeredBy));
        this.dsDao.updateRegisteringUser(dsId, registeredBy);
    }

    @Deprecated
    public void updateDsPlatform(String dsId, String platform) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' platform with '%s'", dsId, platform));
        this.dsDao.updatePlatform(dsId, platform);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/TYPOLOGY", XmlEscapers.xmlContentEscaper().escape(platform));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    public void deleteDs(String dsId) throws DsmException {
        log.info((Object)String.format("deleted datasource '%s'", dsId));
        this.dsDao.deleteDs(dsId);
    }

    public void updateApiOaiSet(String dsId, String apiId, String oaiSet) throws DsmException {
        boolean insert = this.dsDao.upsertApiOaiSet(apiId, oaiSet);
        HashMap changes = Maps.newHashMap();
        changes.put("/ACCESS_PROTOCOL/@set", XmlEscapers.xmlContentEscaper().escape(oaiSet));
        if (!insert) {
            this.isClient.updateAPIField(dsId, apiId, (Map)changes);
        } else {
            this.isClient.addAPIAttribute(dsId, apiId, (Map)changes);
        }
    }

    public void updateApiBaseurl(String dsId, String apiId, String baseUrl) throws DsmException {
        log.info((Object)String.format("updated api '%s' baseurl with '%s'", apiId, baseUrl));
        this.dsDao.updateApiBaseUrl(apiId, baseUrl);
        HashMap changes = Maps.newHashMap();
        changes.put("/BASE_URL", XmlEscapers.xmlContentEscaper().escape(baseUrl));
        this.isClient.updateAPIField(dsId, apiId, (Map)changes);
    }

    public void updateApiCompatibility(String dsId, String apiId, String compliance, boolean override) throws DsmException {
        log.info((Object)String.format("updated api '%s' compliance with '%s'", apiId, compliance));
        this.dsDao.updateCompliance(null, apiId, compliance, override);
        HashMap changes = Maps.newHashMap();
        changes.put("/@compliance", XmlEscapers.xmlAttributeEscaper().escape(compliance));
        this.isClient.updateAPIField(dsId, apiId, (Map)changes);
    }

    public void addApi(ApiDetails api) throws DsmException {
        if (StringUtils.isBlank((CharSequence)api.getId())) {
            api.setId(DsmMappingUtils.createId((ApiDetails)api));
            log.info((Object)String.format("missing api id, created '%s'", api.getId()));
        }
        this.dsDao.addApi((Api)DsmMappingUtils.asDbEntry((ApiDetails)api));
        this.isClient.registerAPI(api);
    }

    public void deleteApi(String apiId) throws DsmForbiddenException, DsmException {
        this.isClient.removeAPI(apiId);
        this.dsDao.deleteApi(null, apiId);
    }

    public void dropCaches() {
        this.mongoLoggerClient.dropCache();
        this.isClient.dropCache();
        this.vocabularyClient.dropCache();
        this.communityClient.dropCache();
    }

    private DatasourceInfo enrichDatasourceInfo(DatasourceDetails d, CountDownLatch outerLatch, Queue<Throwable> errors) {
        DatasourceInfo dsInfo = new DatasourceInfo().setDatasource(d);
        this.getAggregationHistory(d.getId(), outerLatch, errors, dsInfo);
        this.getIndexDsInfo(d.getId(), outerLatch, errors, dsInfo);
        return dsInfo;
    }

    private void getAggregationHistory(String dsId, CountDownLatch outerLatch, Queue<Throwable> errors, DatasourceInfo datasourceInfo) {
        Futures.addCallback((ListenableFuture)this.executor.submit(() -> this.mongoLoggerClient.getAggregationHistory(dsId)), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.executor);
    }

    private void setAggregationHistory(DatasourceInfo datasourceInfo, List<AggregationInfo> info) {
        datasourceInfo.setAggregationHistory(info);
        if (!info.isEmpty()) {
            datasourceInfo.setLastCollection(info.stream().filter(a -> AggregationStage.COLLECT.equals((Object)a.getAggregationStage())).findFirst().get()).setLastTransformation(info.stream().filter(a -> AggregationStage.TRANSFORM.equals((Object)a.getAggregationStage())).findFirst().get());
        }
    }

    private void getIndexDsInfo(String dsId, CountDownLatch outerLatch, Queue<Throwable> errors, DatasourceInfo datasourceInfo) {
        Futures.addCallback((ListenableFuture)this.executor.submit(() -> this.isClient.calculateCurrentIndexDsInfo()), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.executor);
    }

    private void waitLatch(CountDownLatch latch, Queue<Throwable> errors, int waitSeconds) {
        try {
            if (!latch.await(waitSeconds, TimeUnit.SECONDS)) {
                errors.offer(new TimeoutException("Waiting for requests to complete has timed out."));
            }
        }
        catch (InterruptedException e) {
            errors.offer(e);
        }
    }

    static /* synthetic */ void access$000(DsmCore x0, DatasourceInfo x1, List x2) {
        x0.setAggregationHistory(x1, x2);
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ ListeningExecutorService access$200(DsmCore x0) {
        return x0.executor;
    }

    static /* synthetic */ OpenaireExporterConfig access$300(DsmCore x0) {
        return x0.config;
    }

    static /* synthetic */ void access$400(DsmCore x0, CountDownLatch x1, Queue x2, int x3) {
        x0.waitLatch(x1, x2, x3);
    }

    static /* synthetic */ ISClient access$500(DsmCore x0) {
        return x0.isClient;
    }

    static /* synthetic */ ObjectStoreClient access$600(DsmCore x0) {
        return x0.objectStoreClient;
    }

    static /* synthetic */ DatasourceIndexClient access$700(DsmCore x0) {
        return x0.datasourceIndexClient;
    }
}

