/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.openaire.common.Utils;
import eu.dnetlib.openaire.community.CommunityContentprovider;
import eu.dnetlib.openaire.community.CommunityDetails;
import eu.dnetlib.openaire.community.CommunityProject;
import eu.dnetlib.openaire.community.CommunityStatus;
import eu.dnetlib.openaire.community.CommunitySummary;
import eu.dnetlib.openaire.community.CommunityZenodoCommunity;
import eu.dnetlib.openaire.context.Concept;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.context.Param;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommunityMappingUtils {
    private static final String pattern = "yyyy-MM-dd'T'hh:mm:ss";
    private static final Log log = LogFactory.getLog(CommunityMappingUtils.class);

    public static CommunitySummary asCommunitySummary(Context c) {
        CommunitySummary summary = new CommunitySummary();
        summary.setId(c.getId());
        summary.setShortName(c.getLabel());
        summary.setLastUpdateDate(c.getLastUpdateDate());
        summary.setCreationDate(c.getCreationDate());
        summary.setQueryId(c.getId() + "||" + c.getLabel());
        summary.setType(c.getType());
        Map params = c.getParams();
        if (params.containsKey("description")) {
            summary.setDescription(CommunityMappingUtils.asCsv((List)((List)params.get("description"))));
        }
        if (params.containsKey("logourl")) {
            summary.setLogoUrl(CommunityMappingUtils.asCsv((List)((List)params.get("logourl"))));
        }
        if (params.containsKey("status")) {
            summary.setStatus(CommunityStatus.valueOf((String)CommunityMappingUtils.firstValue((Map)params, (String)"status")));
        }
        if (params.containsKey("name")) {
            summary.setName(CommunityMappingUtils.asCsv((List)((List)params.get("name"))));
        }
        if (params.containsKey("manager")) {
            summary.setManagers(CommunityMappingUtils.splitValues((Stream)CommunityMappingUtils.asValues((List)((List)params.get("manager"))), (String)","));
        }
        if (params.containsKey("zenodoCommunity")) {
            summary.setZenodoCommunity(CommunityMappingUtils.asCsv((List)((List)params.get("zenodoCommunity"))));
        }
        return summary;
    }

    public static CommunityDetails asCommunityProfile(Context c) {
        CommunityDetails p = new CommunityDetails(CommunityMappingUtils.asCommunitySummary((Context)c));
        p.setLastUpdateDate(c.getLastUpdateDate());
        Map params = c.getParams();
        if (params.containsKey("subject")) {
            p.setSubjects(CommunityMappingUtils.splitValues((Stream)CommunityMappingUtils.asValues((List)((List)params.get("subject"))), (String)","));
        }
        if (params.containsKey("creationdate")) {
            try {
                p.setCreationDate(DateUtils.parseDate((String)CommunityMappingUtils.asCsv((List)((List)params.get("creationdate"))), (String[])new String[]{"yyyy-MM-dd'T'hh:mm:ss"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return p;
    }

    public static CommunityProject asCommunityProject(String communityId, Concept c) {
        Map p = c.getParams();
        CommunityProject project = new CommunityProject();
        project.setCommunityId(communityId);
        project.setId(StringUtils.substringAfterLast((String)c.getId(), (String)"::"));
        project.setOpenaireId(CommunityMappingUtils.firstValue((Map)p, (String)"openaireId"));
        project.setFunder(CommunityMappingUtils.firstValue((Map)p, (String)"funder"));
        project.setGrantId(CommunityMappingUtils.firstValue((Map)p, (String)"CD_PROJECT_NUMBER"));
        project.setName(CommunityMappingUtils.firstValue((Map)p, (String)"projectfullname"));
        project.setAcronym(CommunityMappingUtils.firstValue((Map)p, (String)"acronym"));
        return project;
    }

    public static CommunityContentprovider asCommunityDataprovider(String communityId, Concept c) {
        Map p = c.getParams();
        CommunityContentprovider d = new CommunityContentprovider();
        d.setCommunityId(communityId);
        d.setId(StringUtils.substringAfterLast((String)c.getId(), (String)"::"));
        d.setOpenaireId(CommunityMappingUtils.firstValue((Map)p, (String)"openaireId"));
        d.setName(CommunityMappingUtils.firstValue((Map)p, (String)"name"));
        d.setOfficialname(CommunityMappingUtils.firstValue((Map)p, (String)"officialname"));
        return d;
    }

    public static CommunityZenodoCommunity asCommunityZenodoCommunity(String communityId, Concept c) {
        CommunityZenodoCommunity z = new CommunityZenodoCommunity();
        Map p = c.getParams();
        z.setCommunityId(communityId);
        z.setId(StringUtils.substringAfterLast((String)c.getId(), (String)"::"));
        z.setZenodoid(CommunityMappingUtils.firstValue((Map)p, (String)"zenodoid"));
        return z;
    }

    private static List<String> splitValues(Stream<String> stream, String separator) {
        return stream.map(s -> s.split(separator)).map(Arrays::asList).flatMap(Collection::stream).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
    }

    private static String firstValue(Map<String, List<Param>> p, String paramName) {
        Optional first = CommunityMappingUtils.asValues(p.get(paramName)).findFirst();
        return first.isPresent() ? (String)first.get() : null;
    }

    private static String asCsv(List<Param> params) {
        return CommunityMappingUtils.asValues(params).collect(Collectors.joining(","));
    }

    private static Stream<String> asValues(List<Param> params) {
        return params == null ? Stream.empty() : params.stream().map(Param::getValue).map(StringUtils::trim).distinct();
    }

    public static String asProjectXML(String contextId, CommunityProject project) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<concept claim='false' id='%s%s%s%s' label='%s'>\n", Utils.escape((Escaper)esc, (String)contextId), "::projects", "::", Utils.escape((Escaper)esc, (String)String.valueOf(project.getId())), Utils.escape((Escaper)esc, (String)project.getAcronym())));
        sb.append(CommunityMappingUtils.paramXML((String)"projectfullname", (String)project.getName()));
        sb.append(CommunityMappingUtils.paramXML((String)"acronym", (String)project.getAcronym()));
        sb.append(CommunityMappingUtils.paramXML((String)"CD_PROJECT_NUMBER", (String)project.getGrantId()));
        sb.append(CommunityMappingUtils.paramXML((String)"funder", (String)project.getFunder()));
        sb.append(CommunityMappingUtils.paramXML((String)"openaireId", (String)project.getOpenaireId()));
        sb.append("</concept>\n");
        return sb.toString();
    }

    public static String asContentProviderXML(String contextId, CommunityContentprovider ccp) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<concept claim='false' id='%s%s%s%s' label='%s'>\n", Utils.escape((Escaper)esc, (String)contextId), "::contentproviders", "::", Utils.escape((Escaper)esc, (String)String.valueOf(ccp.getId())), Utils.escape((Escaper)esc, (String)ccp.getName())));
        sb.append(CommunityMappingUtils.paramXML((String)"openaireId", (String)ccp.getOpenaireId()));
        sb.append(CommunityMappingUtils.paramXML((String)"name", (String)ccp.getName()));
        sb.append(CommunityMappingUtils.paramXML((String)"officialname", (String)ccp.getOfficialname()));
        sb.append(CommunityMappingUtils.paramXML((String)"enabled", (String)"true"));
        sb.append("</concept>\n");
        return sb.toString();
    }

    public static String asZenodoCommunityXML(String contextId, CommunityZenodoCommunity zc) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<concept claim='false' id='%s%s%s%s' label='%s'>\n", Utils.escape((Escaper)esc, (String)contextId), "::zenodocommunities", "::", Utils.escape((Escaper)esc, (String)String.valueOf(zc.getId())), Utils.escape((Escaper)esc, (String)zc.getZenodoid())));
        sb.append(CommunityMappingUtils.paramXML((String)"zenodoid", (String)zc.getZenodoid()));
        sb.append("</concept>\n");
        return sb.toString();
    }

    private static String paramXML(String paramName, String value) {
        return String.format("<param name='%s'>%s</param>\n", paramName, Utils.escape((Escaper)XmlEscapers.xmlContentEscaper(), (String)value));
    }
}

