/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.common;

import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.common.AbstractExporterController;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class AbstractExporterController {
    private static final Log log = LogFactory.getLog(AbstractExporterController.class);

    @ResponseBody
    @ExceptionHandler(value={DsmException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessage handleDSMException(Exception e) {
        return this._handleError(e);
    }

    @ResponseBody
    @ExceptionHandler(value={DsmForbiddenException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public ErrorMessage handleForbiddenException(Exception e) {
        return this._handleError(e);
    }

    @ResponseBody
    @ExceptionHandler(value={DsmNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorMessage handleNotFoundException(Exception e) {
        return this._handleError(e);
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public List<ErrorMessage> processValidationError(MethodArgumentNotValidException e) {
        return e.getBindingResult().getFieldErrors().stream().map(fe -> new ErrorMessage(this, String.format("field '%s'", fe.getField()), String.format("rejected value '%s'", fe.getRejectedValue()), fe.getDefaultMessage())).collect(Collectors.toList());
    }

    private ErrorMessage _handleError(Exception e) {
        log.debug((Object)e.getMessage());
        if (StringUtils.containsIgnoreCase((CharSequence)ExceptionUtils.getRootCauseMessage((Throwable)e), (CharSequence)"Broken pipe")) {
            return null;
        }
        return new ErrorMessage(this, e);
    }
}

