/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.funders;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.funders.FunderDao;
import eu.dnetlib.openaire.funders.FundersApiException;
import eu.dnetlib.openaire.funders.domain.ExtendedFunderDetails;
import eu.dnetlib.openaire.funders.domain.FunderDetails;
import eu.dnetlib.openaire.funders.domain.db.FunderDbEntry;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.funders"}, havingValue="true")
@Api(tags={"OpenAIRE funders API"}, description="the OpenAIRE funders API")
public class FundersApiController
extends AbstractExporterController {
    private static final Log log = LogFactory.getLog(FundersApiController.class);
    @Autowired
    private FunderDao fDao;

    @RequestMapping(value={"/funders"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get basic information about funders", notes="basic information about funders: id, name, shortname, last update date, registration date", response=FunderDetails[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=FunderDetails[].class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public List<FunderDetails> getFunders(@PathVariable int page, @PathVariable int size) throws FundersApiException {
        return this.fDao.listFunderDetails(page, size);
    }

    @RequestMapping(value={"/funder/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the funder details", notes="complete funder information", response=FunderDbEntry.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=FunderDbEntry.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public ExtendedFunderDetails getFunderDetails(@PathVariable String id) throws FundersApiException {
        return this.fDao.getExtendedFunderDetails(id);
    }

    @RequestMapping(value={"/funder/ids"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the list of funder ids", notes="get the list of funder ids", response=String[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String[].class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public List<String> getFunderIds(@PathVariable int page, @PathVariable int size) throws FundersApiException {
        return this.fDao.listFunderIds(page, size);
    }
}

