/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib;

import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.openaire.community.CommunityApiController;
import eu.dnetlib.openaire.context.ContextApiController;
import eu.dnetlib.openaire.dsm.DsmApiController;
import eu.dnetlib.openaire.funders.FundersApiController;
import eu.dnetlib.openaire.project.ProjectsController;
import java.sql.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    private static final Log log = LogFactory.getLog(SwaggerConfig.class);
    public static String V1 = "1.0.0";
    @Autowired
    private OpenaireExporterConfig config;

    @Bean
    public Docket dsm() {
        return this._docket("Datasource Manager", DsmApiController.class.getPackage().getName(), this.config.getSwaggerDsm(), V1);
    }

    @Bean
    public Docket projects() {
        return this._docket("OpenAIRE Projects", ProjectsController.class.getPackage().getName(), this.config.getSwaggerProjects(), V1);
    }

    @Bean
    public Docket funders() {
        return this._docket("OpenAIRE Funders", FundersApiController.class.getPackage().getName(), this.config.getSwaggerFunders(), V1);
    }

    @Bean
    public Docket communities() {
        return this._docket("OpenAIRE Communities", CommunityApiController.class.getPackage().getName(), this.config.getSwaggerCommunities(), V1);
    }

    @Bean
    public Docket contexts() {
        return this._docket("OpenAIRE Contexts", ContextApiController.class.getPackage().getName(), this.config.getSwaggerCommunities(), V1);
    }

    private Docket _docket(String groupName, String controllerPackage, OpenaireExporterConfig.Swagger swag, String version) {
        return new Docket(DocumentationType.SWAGGER_2).groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)controllerPackage)).build().directModelSubstitute(LocalDate.class, Date.class).directModelSubstitute(DateTime.class, java.util.Date.class).apiInfo(this.apiInfo(swag, version));
    }

    private ApiInfo apiInfo(OpenaireExporterConfig.Swagger swag, String version) {
        return new ApiInfoBuilder().title(swag.getApiTitle()).description(swag.getApiDescription()).license(swag.getApiLicense()).licenseUrl(swag.getApiLicenseUrl()).termsOfServiceUrl("").version(version).contact(new Contact(swag.getApiContactName(), swag.getApiContactUrl(), swag.getApiContactEmail())).build();
    }
}

