/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib;

import com.google.common.collect.Lists;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DNetOpenaireExporterBeanFactory {
    private static final Log log = LogFactory.getLog(DNetOpenaireExporterBeanFactory.class);
    @Autowired
    private OpenaireExporterConfig config;

    @Bean
    public ISLookUpService getLookUpService() {
        return (ISLookUpService)this.getServiceStub(ISLookUpService.class, this.config.getIsLookupUrl());
    }

    @Bean
    public ObjectStoreService getObjectStoreService() {
        return (ObjectStoreService)this.getServiceStub(ObjectStoreService.class, this.config.getObjectStoreServiceUrl());
    }

    @Bean
    public ISRegistryService getRegistryService() {
        return (ISRegistryService)this.getServiceStub(ISRegistryService.class, this.config.getIsRegistryServiceUrl());
    }

    private <T> T getServiceStub(Class<T> clazz, String endpoint) {
        log.info((Object)String.format("Initializing service stub %s, endpoint %s", clazz.toString(), endpoint));
        JaxWsProxyFactoryBean jaxWsProxyFactory = new JaxWsProxyFactoryBean();
        jaxWsProxyFactory.setServiceClass(clazz);
        jaxWsProxyFactory.setAddress(endpoint);
        return (T)jaxWsProxyFactory.create();
    }

    @Bean
    public DataSource getSqlDataSource() {
        OpenaireExporterConfig.Jdbc jdbc = this.config.getJdbc();
        return this.getDatasource(jdbc.getDriverClassName(), jdbc.getUrl(), jdbc.getUser(), jdbc.getPwd(), jdbc.getMinIdle(), jdbc.getMaxRows());
    }

    private BasicDataSource getDatasource(String driverClassName, String jdbcUrl, String jdbcUser, String jdbcPwd, int jdbcMinIdle, int jdbcMaxIdle) {
        BasicDataSource d = new BasicDataSource();
        d.setDriverClassName(driverClassName);
        d.setUrl(jdbcUrl);
        d.setUsername(jdbcUser);
        d.setPassword(jdbcPwd);
        d.setMinIdle(jdbcMinIdle);
        d.setMaxIdle(jdbcMaxIdle);
        return d;
    }

    @Bean
    public MongoClient getMongoClient() {
        return new MongoClient(new ServerAddress(this.config.getDatasource().getMongoHost(), this.config.getDatasource().getMongoPort()), MongoClientOptions.builder().connectionsPerHost(this.config.getDatasource().getMongoConnectionsPerHost()).build());
    }

    static {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            Model model = reader.read((Reader)new FileReader("pom.xml"));
            log.info((Object)String.format("registering metric for %s", model.getArtifactId()));
            Metrics.gauge((String)"micrometer_info", (Iterable)Lists.newArrayList((Object[])new Tag[]{new ImmutableTag("component", model.getGroupId() + ":" + model.getArtifactId()), new ImmutableTag("version", model.getVersion()), new ImmutableTag("scmtag", model.getScm().getTag())}), (Number)1);
        }
        catch (IOException | XmlPullParserException e) {
            log.error((Object)e);
        }
    }
}

