/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.context;

import com.google.common.base.Splitter;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.context.Category;
import eu.dnetlib.openaire.context.CategorySummary;
import eu.dnetlib.openaire.context.Concept;
import eu.dnetlib.openaire.context.ConceptSummary;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.context.ContextException;
import eu.dnetlib.openaire.context.ContextSummary;
import eu.dnetlib.openaire.context.Param;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.context"}, havingValue="true")
public class ContextApiCore {
    private static final Log log = LogFactory.getLog(ContextApiCore.class);
    private static final String SEPARATOR = "::";
    @Autowired
    private ISClient isClient;

    public List<ContextSummary> listContexts() throws ContextException {
        return this.getContextMap().values().stream().map(c -> new ContextSummary().setId(c.getId()).setType(c.getType()).setLabel(c.getLabel()).setStatus(c.getParams().containsKey("status") ? ((Param)((List)c.getParams().get("status")).get(0)).getValue() : "")).collect(Collectors.toList());
    }

    public List<CategorySummary> listCategories(String contextId) throws ContextException {
        return ((Context)this.getContextMap().get(contextId)).getCategories().values().stream().filter(Category::isClaim).map(c -> new CategorySummary().setId(c.getId()).setLabel(c.getLabel()).setHasConcept(c.hasConcepts())).collect(Collectors.toList());
    }

    public List<ConceptSummary> listConcepts(String categoryId) throws ContextException {
        String contextId = StringUtils.substringBefore((String)categoryId, (String)SEPARATOR);
        return ((Category)((Context)this.getContextMap().get(contextId)).getCategories().get(categoryId)).getConcepts().stream().filter(Concept::isClaim).map(c -> new ConceptSummary().setId(c.getId()).setLabel(c.getLabel()).setHasSubConcept(c.hasSubConcepts())).collect(Collectors.toList());
    }

    public List<ConceptSummary> listSubConcepts(String conceptId) throws ContextException {
        List ids = Splitter.on((String)SEPARATOR).splitToList((CharSequence)conceptId);
        if (ids.size() < 3) {
            throw new ContextException("");
        }
        String contextId = (String)ids.get(0);
        String categoryId = contextId + SEPARATOR + (String)ids.get(1);
        List concepts = ((Category)((Context)this.getContextMap().get(contextId)).getCategories().get(categoryId)).getConcepts().stream().filter(c -> conceptId.equals(c.getId())).filter(Concept::isClaim).collect(Collectors.toList());
        return this.mapConcepts(concepts);
    }

    private List<ConceptSummary> mapConcepts(List<Concept> concepts) {
        if (concepts == null || concepts.isEmpty()) {
            return null;
        }
        return concepts.stream().map(c -> new ConceptSummary().setId(c.getId()).setLabel(c.getLabel()).setHasSubConcept(c.hasSubConcepts()).setConcept(this.mapConcepts(c.getConcepts()))).collect(Collectors.toList());
    }

    private Map<String, Context> getContextMap() throws ContextException {
        try {
            return this.isClient.getContextMap();
        }
        catch (IOException e) {
            throw new ContextException(e);
        }
    }
}

