/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.datasources.common.AggregationInfo;
import eu.dnetlib.enabling.datasources.common.AggregationStage;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.openaire.common.Utils;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClient;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class MongoLoggerClientImpl
implements MongoLoggerClient {
    private static final Log log = LogFactory.getLog(MongoLoggerClientImpl.class);
    @Autowired
    private MongoClient datasourcePublisherMongoClient;
    @Autowired
    private OpenaireExporterConfig config;
    private static final String LOADTIME = "loadtime";
    private LoadingCache<String, Instant> loadingCache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private static Bson fields = MongoLoggerClientImpl.getFields();
    private static MongoCollection<Document> collection = null;

    @Cacheable(value={"dsm-aggregationhistory-cache"})
    public List<AggregationInfo> getAggregationHistory(String dsId) throws DsmException {
        log.warn((Object)String.format("getAggregationHistory(dsId = %s): not using cache", dsId));
        OpenaireExporterConfig.Datasource conf = this.config.getDatasource();
        try {
            FindIterable aggregationDocs = this.getCollection().find(this.queryForAggregationHistory(dsId, "(collect|transform)")).projection(fields).limit(conf.getMongoQueryLimit()).sort((Bson)MongoLoggerClientImpl.dbo((String)"system:startHumanDate", (Object)-1));
            List<AggregationInfo> aggregationInfos = Utils.stream((Iterator)aggregationDocs.iterator()).map(this.getMapper()).filter(ai -> ai.getNumberOfRecords() >= 0 && StringUtils.isNotBlank((String)ai.getDate())).collect(Collectors.toList());
            Instant loadTime = (Instant)this.loadingCache.get((Object)"loadtime");
            if (loadTime != null) {
                for (AggregationInfo a : aggregationInfos) {
                    if (!this.asInstant(a).isBefore(loadTime) || !AggregationStage.COLLECT.equals((Object)a.getAggregationStage())) continue;
                    a.setIndexedVersion(true);
                    break;
                }
            }
            return aggregationInfos;
        }
        catch (Throwable e) {
            throw new DsmException(500, String.format("error reading aggregation history for '%s'", dsId), e);
        }
    }

    private Instant getLoadTime() {
        log.warn((Object)"querying for metadata load time, not using cache");
        Document first = (Document)this.getCollection().find(this.queryForLastMetadataLoad()).sort((Bson)MongoLoggerClientImpl.dbo((String)"system:startHumanDate", (Object)-1)).first();
        if (first == null) {
            return null;
        }
        String startDate = (String)first.getOrDefault((Object)"system:startHumanDate", (Object)"");
        if (StringUtils.isBlank((String)startDate)) {
            return null;
        }
        return Instant.parse(startDate.replaceAll("\\+.*", "Z"));
    }

    private Instant asInstant(AggregationInfo a) {
        return Instant.parse(a.getDate() + "T00:00:00Z");
    }

    @CacheEvict(cacheNames={"dsm-aggregationhistory-cache", "dsm-firstharvestdate-cache"}, allEntries=true)
    public void dropCache() {
        log.info((Object)"dropped dsManager aggregation history cache");
    }

    private Function<Document, AggregationInfo> getMapper() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getDate(Document d) {
        String dateString = d.getString((Object)"system:startHumanDate");
        if (StringUtils.isBlank((String)dateString)) {
            return "";
        }
        return DateFormatUtils.format((Date)new DateUtils().parse(dateString), (String)"yyyy-MM-dd");
    }

    private static Bson getFields() {
        return Projections.fields((Bson[])new Bson[]{Filters.eq((String)"system:wfName", (Object)1), Filters.eq((String)"system:node:SELECT_MODE:selection", (Object)1), Filters.eq((String)"mainlog:sinkSize", (Object)1), Filters.eq((String)"mainlog:writeOps", (Object)1), Filters.eq((String)"mainlog:total", (Object)1), Filters.eq((String)"system:startHumanDate", (Object)1), Filters.eq((String)"system:profileName", (Object)1)});
    }

    private static BasicDBObject dbo(String key, Object value) {
        return new BasicDBObject(key, value);
    }

    private Bson queryForAggregationHistory(String dsId, String pattern) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentDatasourceId", (Object)dsId), Filters.eq((String)"system:profileFamily", (Object)"aggregator"), Filters.eq((String)"system:isCompletedSuccessfully", (Object)"true"), Filters.regex((String)"system:wfName", (String)pattern, (String)"i")});
    }

    private Bson queryForLastMetadataLoad() {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"system:profileId", (Object)this.config.getOaf2HBaseWfId()), Filters.eq((String)"system:isCompletedSuccessfully", (Object)"true"), Filters.eq((String)"system:node:reuseHdfsRecords:reuseMdRecords", (Object)"false")});
    }

    private synchronized MongoCollection<Document> getCollection() {
        if (collection == null) {
            log.info((Object)"inizializing mongodb collection ...");
            OpenaireExporterConfig.Datasource conf = this.config.getDatasource();
            collection = this.datasourcePublisherMongoClient.getDatabase(conf.getMongoDbName()).getCollection(conf.getMongoCollectionName());
        }
        return collection;
    }

    static /* synthetic */ Instant access$000(MongoLoggerClientImpl x0) {
        return x0.getLoadTime();
    }

    static /* synthetic */ String access$100(MongoLoggerClientImpl x0, Document x1) {
        return x0.getDate(x1);
    }
}

