package eu.dnetlib;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@EnableCaching
@RestController
@SpringBootApplication
//@EnableAspectJAutoProxy
@EnableAutoConfiguration(exclude = { SolrAutoConfiguration.class })
public class DNetOpenaireExporterApplication {

	@RequestMapping(value = { "/", "/docs" })
	public void index(final HttpServletResponse response) throws IOException {
		response.sendRedirect("swagger-ui.html");
	}

	public static void main(String[] args) throws Exception {
		SpringApplication.run(DNetOpenaireExporterApplication.class, args);
	}

}
