package eu.dnetlib.openaire.dsm.domain.db;

import java.sql.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

import eu.dnetlib.enabling.datasources.common.Datasource;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;

/**
 * Datasource
 */
@Entity
@DynamicUpdate
@SelectBeforeUpdate
@Table(name = "dsm_datasources")
public class DatasourceDbEntry extends Datasource<OrganizationDbEntry, IdentityDbEntry> {

	@Transient
	private String openaireId;

	@Column(name = "lastconsenttermsofusedate")
	private Date lastConsentTermsOfUseDate;
	
	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public Date getLastConsentTermsOfUseDate() {
		return lastConsentTermsOfUseDate;
	}
	
	public void setLastConsentTermsOfUseDate(Date lastConsentTermsOfUseDate) {
		this.lastConsentTermsOfUseDate = lastConsentTermsOfUseDate;
	}
}
