package eu.dnetlib.openaire.dsm.dao;

import java.util.List;
import java.util.Queue;

import com.google.common.collect.Lists;

import eu.dnetlib.openaire.dsm.domain.*;

public class ResponseUtils {

	public static ApiDetailsResponse apiResponse(final List<ApiDetails> api, final long total) {
		final ApiDetailsResponse rsp = new ApiDetailsResponse().setApi(api);
		rsp.setHeader(header(total));
		return rsp;
	}

	public static DatasourceSnippetResponse snippetResponse(final List<DatasourceSnippetExtended> snippets, final long total) {
		final DatasourceSnippetResponse rsp = new DatasourceSnippetResponse(snippets);
		rsp.setHeader(header(total));
		return rsp;
	}

	public static DatasourceDetailResponse detailsResponse(final List<DatasourceDetails> details, final long total) {
		final DatasourceDetailResponse rsp = new DatasourceDetailResponse(details);
		rsp.setHeader(header(total));
		return rsp;
	}

	public static DatasourceSearchResponse searchResponse(final List<DatasourceInfo> infos, final long total) {
		final DatasourceSearchResponse rsp = new DatasourceSearchResponse(infos);
		rsp.setHeader(header(total));
		return rsp;
	}


	public static Header header(final Queue<Throwable> errors, final long total) {
		return Header.newInsance()
				.setExceptions(errors)
				.setTotal(total);
	}

	public static Header header(final long total) {
		return header(Lists.newLinkedList(), total);
	}

	public static SimpleResponse simpleResponse(final List<?> list) {
		final SimpleResponse rsp = new SimpleResponse().setResponse(list);;
		rsp.setHeader(header(Lists.newLinkedList(), list.size()));
		return rsp;
	}

}
