package eu.dnetlib.openaire.usermanagement;

import java.io.Serializable;

public class ServiceRequest {
    String client_name;
    String client_id;
    String logo_uri;
    String policy_uri;
    String[] contacts;
    String[] redirect_uris = new String[]{};
    String[] grant_types = new String[] {"client_credentials"};
    String token_endpoint_auth_method = "private_key_jwt";
    String token_endpoint_auth_signing_alg = "RS256";
    String jwks_uri;
    Jwks jwks;

    public String getClientName() {
        return client_name;
    }

    public void setClientName(String clientName) {
        this.client_name = clientName;
    }

    public String getClientId() {
        return client_id;
    }

    public void setClientId(String clientId) {
        this.client_id = clientId;
    }

    public String[] getRedirectUris() {
        return redirect_uris;
    }

    public void setRedirectUris(String[] redirectUris) {
        this.redirect_uris = redirectUris;
    }

    public String getLogoUri() {
        return logo_uri;
    }

    public void setLogoUri(String logoUri) {
        this.logo_uri = logoUri;
    }

    public String getPolicyUri() {
        return policy_uri;
    }

    public void setPolicyUri(String policyUri) {
        this.policy_uri = policyUri;
    }

    public String[] getContacts() {
        return contacts;
    }

    public void setContacts(String[] contacts) {
        this.contacts = contacts;
    }

    public String[] getGrantTypes() {
        return grant_types;
    }

    public void setGrantTypes(String[] grantTypes) {
        this.grant_types = grantTypes;
    }

    public String getToken_endpoint_auth_method() {
        return token_endpoint_auth_method;
    }

    public void setToken_endpoint_auth_method(String token_endpoint_auth_method) {
        this.token_endpoint_auth_method = token_endpoint_auth_method;
    }

    public String getTokenEndpointAuthSigningAlg() {
        return token_endpoint_auth_signing_alg;
    }

    public void setTokenEndpointAuthSigningAlg(String tokenEndpointAuthSigningAlg) {
        this.token_endpoint_auth_signing_alg = tokenEndpointAuthSigningAlg;
    }

    public String getJwksUri() {
        return jwks_uri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwks_uri = jwksUri;
    }

    public Jwks getJwks() {
        return jwks;
    }

    public void setJwks(Jwks jwks) {
        this.jwks = jwks;
    }
}

class Jwks implements Serializable {
    Key[] keys;

    public Key[] getKeys() {
        return keys;
    }

    public void setKeys(Key[] keys) {
        this.keys = keys;
    }
}

class Key implements Serializable {
    String kty;
    String e;
    String kid;
    String alg;
    String n;

    public String getKty() {
        return kty;
    }

    public void setKty(String kty) {
        this.kty = kty;
    }

    public String getE() {
        return e;
    }

    public void setE(String e) {
        this.e = e;
    }

    public String getKid() {
        return kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getAlg() {
        return alg;
    }

    public void setAlg(String alg) {
        this.alg = alg;
    }

    public String getN() {
        return n;
    }

    public void setN(String n) {
        this.n = n;
    }
}





