package eu.dnetlib.openaire.usermanagement.utils;

import com.google.gson.Gson;
import eu.dnetlib.openaire.usermanagement.ServiceResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Component
public class TokenUtils {

    private Logger logger = Logger.getLogger(TokenUtils.class);

    @Value("${oidc.issuer}")
    private String issuer;

    public String registerService(String serverRequestJSON)
            throws IOException {

        HttpPost httppost = new HttpPost( issuer + "register");
        httppost.setHeader(HttpHeaders.CONTENT_TYPE, "application/json");
        StringEntity params = new StringEntity(serverRequestJSON);
        httppost.setEntity(params);

        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpResponse httpResponse = httpclient.execute(httppost);

        //System.out.println("HTTP RESPONSE " + httpResponse.getStatusLine().getStatusCode());
        if (httpResponse.getStatusLine().getStatusCode() == 201) {
            //logger.debug(IOUtils.toString(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8.name()));
            return IOUtils.toString(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8.name());
        }

        return null;
    }

    public HttpResponse updateService(String serviceId, String serviceSON, String registeredAccessToken) throws IOException {

            HttpPut httpPut = new HttpPut(issuer + "register/"+serviceId);
            httpPut.setHeader(HttpHeaders.CONTENT_TYPE, "application/json");
            httpPut.setHeader(HttpHeaders.AUTHORIZATION, "Bearer " + registeredAccessToken);
            StringEntity params = new StringEntity(serviceSON.toString());
            httpPut.setEntity(params);

            CloseableHttpClient httpclient = HttpClients.createDefault();
            return httpclient.execute(httpPut);
    }

    public HttpResponse deleteService(String serviceId, String registeredAccessToken) throws IOException {

        //System.out.println("DELETE " + issuer + "register/"+serviceId);
        HttpDelete httpDelete = new HttpDelete(issuer + "register/"+serviceId);
        httpDelete.setHeader(HttpHeaders.CONTENT_TYPE, "application/json");
        httpDelete.setHeader(HttpHeaders.AUTHORIZATION, "Bearer " + registeredAccessToken);

        CloseableHttpClient httpclient = HttpClients.createDefault();
        return httpclient.execute(httpDelete);
    }

    public ServiceResponse getRegisteredService(String serviceId, String registeredAccessToken) throws IOException {
        //System.out.println("ISSUER " + issuer);
        HttpGet httpGet = new HttpGet(issuer + "register/"+ serviceId);
        httpGet.setHeader(HttpHeaders.AUTHORIZATION, "Bearer " + registeredAccessToken);

        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpResponse httpResponse = httpclient.execute(httpGet);
        String registeredService = IOUtils.toString(httpResponse.getEntity().getContent(), StandardCharsets.UTF_8.name());
        //System.out.println(registeredService);
        return new Gson().fromJson(registeredService,ServiceResponse.class);
    }

    public void viewRegisteredServices(List<String> serviceIds, String registeredAccessToken) throws IOException {
        for (String serviceId: serviceIds) {
            getRegisteredService(serviceId, registeredAccessToken);
        }
    }
}
