/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import eu.dnetlib.openaire.user.pojos.RegisteredService;
import eu.dnetlib.openaire.usermanagement.Jwks;
import eu.dnetlib.openaire.usermanagement.JwksDeserializer;
import eu.dnetlib.openaire.usermanagement.Key;
import eu.dnetlib.openaire.usermanagement.ServiceRequest;
import eu.dnetlib.openaire.usermanagement.ServiceResponse;
import eu.dnetlib.openaire.usermanagement.utils.RegisteredServicesUtils;
import eu.dnetlib.openaire.usermanagement.utils.TokenUtils;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.http.HttpResponse;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegisterServiceServlet
extends HttpServlet {
    private Logger logger = Logger.getLogger(RegisterServiceServlet.class);
    @Autowired
    private RegisteredServicesUtils registeredServicesUtils;
    @Autowired
    private TokenUtils tokenUtils;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
            String userid = authentication.getSub();
            StringBuilder name = new StringBuilder().append(authentication.getUserInfo().getGivenName().charAt(0));
            name.append(authentication.getUserInfo().getFamilyName().charAt(0));
            request.getSession().setAttribute("name", (Object)name.toString());
            String idParam = request.getParameter("id");
            if (idParam != null && !idParam.isEmpty()) {
                try {
                    int id = Integer.parseInt(idParam);
                    RegisteredService registeredService = this.registeredServicesUtils.getRegisteredServiceDao().fetchRegisteredServiceById(id);
                    if (registeredService != null && this.registeredServicesUtils.isAuthorized(userid, id)) {
                        ServiceResponse serviceResponse = this.tokenUtils.getRegisteredService(registeredService.getClientId(), registeredService.getRegistrationAccessToken());
                        this.updateFormFields(request, registeredService.getName(), registeredService.getKeyType(), serviceResponse);
                        break block7;
                    }
                    if (registeredService == null) {
                        request.getSession().setAttribute("message", (Object)("Not valid registered service with given id " + id + "."));
                        response.sendRedirect("./registeredServices");
                        this.logger.warn((Object)("Not valid registered service with " + id + "id."));
                        break block7;
                    }
                    request.getSession().setAttribute("message", (Object)("Not authorized to edit the registered service with id " + id + "."));
                    response.sendRedirect("./registeredServices");
                    this.logger.warn((Object)("Not authorized to edit the service with " + id + "id."));
                }
                catch (NumberFormatException nfe) {
                    request.getSession().setAttribute("message", (Object)"Invalid service id.");
                    response.sendRedirect("./registeredServices");
                    this.logger.error((Object)"Invalid service id.", (Throwable)nfe);
                }
                catch (SQLException sqle) {
                    request.getSession().setAttribute("message", (Object)"Could not fetch registered service.");
                    response.sendRedirect("./registeredServices");
                    this.logger.error((Object)"Could not fetch registered service.", (Throwable)sqle);
                }
            } else {
                request.getSession().setAttribute("first_name", null);
                request.getSession().setAttribute("key_type", null);
                request.getSession().setAttribute("jwksUri", null);
                request.getSession().setAttribute("value", null);
                this.checkNumberOfRegisteredServices(request, response, authentication);
            }
        }
        response.setContentType("text/html");
        request.getRequestDispatcher("./registerService.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    private void updateFormFields(HttpServletRequest request, String serviceName, String keyType, ServiceResponse serviceResponse) {
        request.getSession().setAttribute("first_name", (Object)serviceName);
        request.getSession().setAttribute("key_type", (Object)keyType);
        if (keyType != null) {
            if (keyType.equals("uri")) {
                request.getSession().setAttribute("jwksUri", (Object)serviceResponse.getJwksUri());
            } else {
                Key key = serviceResponse.getJwks() != null ? serviceResponse.getJwks().keys[0] : new Key();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                request.getSession().setAttribute("value", (Object)gson.toJson((Object)key));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block35: {
            String jwksString;
            String jwksUri;
            String keyType;
            String name;
            String serviceId;
            block36: {
                String email;
                Jwks jwks;
                OIDCAuthenticationToken authentication;
                block37: {
                    authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
                    response.setContentType("text/html");
                    boolean canProceed = true;
                    String mode = request.getParameter("mode").trim();
                    this.checkmode(mode);
                    serviceId = request.getParameter("id");
                    name = request.getParameter("first_name").trim();
                    if (name.isEmpty()) {
                        request.getSession().setAttribute("first_name_error", (Object)true);
                        canProceed = false;
                    }
                    keyType = request.getParameter("key_type");
                    jwksUri = null;
                    jwksString = null;
                    jwks = null;
                    if (keyType != null) {
                        if ((keyType = keyType.trim()).equals("uri")) {
                            jwksUri = request.getParameter("uri");
                            request.getSession().setAttribute("jwksUri", (Object)jwksUri);
                            String[] schemes = new String[]{"https"};
                            UrlValidator urlValidator = new UrlValidator(schemes);
                            if (!urlValidator.isValid(jwksUri)) {
                                request.getSession().setAttribute("uri_error", (Object)true);
                                canProceed = false;
                            }
                        } else {
                            jwksString = request.getParameter("value");
                            try {
                                Gson gson = new GsonBuilder().registerTypeAdapter(Jwks.class, (Object)new JwksDeserializer()).create();
                                String jwksSet = String.format("{\"keys\":[%s]}", jwksString);
                                jwks = (Jwks)gson.fromJson(jwksSet, Jwks.class);
                                request.getSession().setAttribute("value", (Object)jwksString);
                                if (jwks.getKeys() == null || jwks.getKeys().length == 0) {
                                    request.getSession().setAttribute("value_error", (Object)true);
                                    canProceed = false;
                                }
                            }
                            catch (JsonParseException jpe) {
                                request.getSession().setAttribute("value_error", (Object)true);
                                canProceed = false;
                            }
                        }
                    }
                    String userid = authentication.getSub();
                    email = authentication.getUserInfo().getEmail();
                    ServiceResponse serviceResponse = null;
                    if (!this.nameIsValid(name) || !this.userInfoIsValid(userid, email) || !this.keyIsValid(keyType, jwksUri, jwksString) || !canProceed) break block36;
                    if (!mode.equals("create")) break block37;
                    if (!this.checkNumberOfRegisteredServices(request, response, authentication)) {
                        return;
                    }
                    String serverRequestJSON = null;
                    if (keyType == null) {
                        serverRequestJSON = RegisterServiceServlet.createServiceJson(null, (String)name, (String)email);
                    } else if (keyType.equals("uri")) {
                        serverRequestJSON = RegisterServiceServlet.createServiceJson(null, (String)name, (String)email, (String)jwksUri);
                    } else if (keyType.equals("value")) {
                        serverRequestJSON = RegisterServiceServlet.createServiceJson(null, (String)name, (String)email, (Jwks)jwks);
                    }
                    if (serverRequestJSON == null) {
                        this.logger.error((Object)"Service request JSON is null");
                        request.getSession().setAttribute("message", (Object)"There was an error registering your service. Please try again later.");
                        response.sendRedirect("./registeredServices");
                        return;
                    }
                    String serverMessage = this.tokenUtils.registerService(serverRequestJSON);
                    this.logger.debug((Object)serverMessage);
                    if (serverMessage == null) {
                        request.getSession().setAttribute("message", (Object)"There was an error registering your service. Please try again later.");
                        response.sendRedirect("./registeredServices");
                        return;
                    }
                    serviceResponse = (ServiceResponse)new Gson().fromJson(serverMessage, ServiceResponse.class);
                    String client_id = serviceResponse.getClientId();
                    RegisteredService registeredService = new RegisteredService(client_id, userid, name, serviceResponse.getRegistrationAccessToken(), keyType);
                    try {
                        this.registeredServicesUtils.addRegistedService(registeredService);
                        if (registeredService.getKeyType() != null) {
                            request.getSession().setAttribute("success", (Object)("Your service has been successfully registered!<br><b>Client ID</b>: " + serviceResponse.getClientId()));
                        }
                        request.getSession().setAttribute("success", (Object)("Your service has been successfully registered!<br><b>Client ID</b>: " + serviceResponse.getClientId() + "<br><span style=\"word-wrap: break-word\"><b>Client Secret</b>:" + serviceResponse.getClientSecret() + "</span>"));
                    }
                    catch (SQLException sqle) {
                        this.logger.error((Object)"Fail to save service.", (Throwable)sqle);
                        request.getSession().setAttribute("message", (Object)"There was an error registering your service. Please try again later.");
                        response.sendRedirect("./registeredServices");
                        return;
                    }
                }
                int serviceIdInt = 0;
                if (serviceId == null || serviceId.isEmpty()) {
                    request.getSession().setAttribute("message", (Object)("Service with id " + serviceId + " does not exist."));
                    response.sendRedirect("./registeredServices");
                    break block35;
                } else {
                    try {
                        serviceIdInt = Integer.parseInt(serviceId);
                        if (!this.registeredServicesUtils.isAuthorized(authentication.getSub(), serviceIdInt)) {
                            request.getSession().setAttribute("message", (Object)"You have no permission to edit the service.");
                            response.sendRedirect("./registeredServices");
                            break block35;
                        }
                        RegisteredService registeredService = this.registeredServicesUtils.getRegisteredServiceDao().fetchRegisteredServiceById(serviceIdInt);
                        if (registeredService != null && registeredService.getClientId() != null) {
                            String serverRequestJSON = null;
                            if (keyType == null) {
                                serverRequestJSON = RegisterServiceServlet.createServiceJson((String)registeredService.getClientId(), (String)name, (String)email);
                            } else if (keyType.equals("uri")) {
                                serverRequestJSON = RegisterServiceServlet.createServiceJson((String)registeredService.getClientId(), (String)name, (String)email, (String)jwksUri);
                            } else if (keyType.equals("value")) {
                                serverRequestJSON = RegisterServiceServlet.createServiceJson((String)registeredService.getClientId(), (String)name, (String)email, (Jwks)jwks);
                            }
                            if (serverRequestJSON == null) {
                                request.getSession().setAttribute("message", (Object)("Service with id " + serviceId + " does not exist."));
                                response.sendRedirect("./registeredServices");
                                return;
                            }
                            HttpResponse resp = this.tokenUtils.updateService(registeredService.getClientId(), serverRequestJSON, registeredService.getRegistrationAccessToken());
                            if (resp.getStatusLine().getStatusCode() != 200) break block35;
                            registeredService.setName(name);
                            try {
                                this.registeredServicesUtils.getRegisteredServiceDao().update(registeredService);
                            }
                            catch (SQLException sqle) {
                                this.logger.error((Object)"Unable to contact db.", (Throwable)sqle);
                                request.getSession().setAttribute("message", (Object)"Fail to delete the service. Please try again later.");
                                response.setContentType("text/html");
                                request.getRequestDispatcher("./registeredServices.jsp").include((ServletRequest)request, (ServletResponse)response);
                                return;
                            }
                            request.getSession().setAttribute("success", (Object)("Your service has been successfully updated!<br><b>Client ID</b>: " + registeredService.getClientId()));
                            break block35;
                        }
                        this.logger.error((Object)"Service request JSON is null");
                        request.getSession().setAttribute("message", (Object)"There was an error registering your service. Please try again later.");
                        response.sendRedirect("./registeredServices");
                        return;
                    }
                    catch (SQLException sqle) {
                        this.logger.error((Object)("Unable to access service with id " + serviceId), (Throwable)sqle);
                        request.getSession().setAttribute("message", (Object)"There was an error accessing your service.");
                        response.sendRedirect("./registeredServices");
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error((Object)("Unable to access service with id " + serviceId), (Throwable)nfe);
                        request.getSession().setAttribute("message", (Object)("Service with id " + serviceId + " does not exist."));
                        response.sendRedirect("./registeredServices");
                    }
                }
                break block35;
            }
            request.getSession().setAttribute("first_name", (Object)name);
            request.getSession().setAttribute("key_type", (Object)keyType);
            request.getSession().setAttribute("uri", (Object)jwksUri);
            request.getSession().setAttribute("value", (Object)jwksString);
            if (serviceId != null && !serviceId.isEmpty()) {
                request.getRequestDispatcher("./registerService.jsp?id=" + serviceId).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            request.getRequestDispatcher("./registerService.jsp").include((ServletRequest)request, (ServletResponse)response);
            return;
        }
        response.sendRedirect("./registeredServices");
    }

    private void checkmode(String mode) {
        if (mode != null && !mode.isEmpty()) {
            if (!mode.equals("edit") || mode.equals("create")) {
                mode = "create";
            }
        } else {
            mode = "create";
        }
    }

    private boolean keyIsValid(String keyType, String jwksUri, String jwksString) {
        return keyType == null || keyType.equals("uri") && jwksUri != null && !jwksUri.isEmpty() || keyType.equals("value") && jwksString != null && !jwksString.isEmpty();
    }

    private boolean userInfoIsValid(String userid, String email) {
        return userid != null && !userid.isEmpty() && email != null && !email.isEmpty();
    }

    private boolean nameIsValid(String name) {
        return name != null && !name.isEmpty();
    }

    private boolean checkNumberOfRegisteredServices(HttpServletRequest request, HttpServletResponse response, OIDCAuthenticationToken authentication) throws IOException {
        try {
            long numberOfRegisteredServices = this.registeredServicesUtils.getRegisteredServiceDao().countRegisteredServices(authentication.getSub());
            if (numberOfRegisteredServices >= 5L) {
                response.sendRedirect("./registeredServices");
                return false;
            }
        }
        catch (SQLException sqle) {
            this.logger.error((Object)"Unable to count registered services.", (Throwable)sqle);
            request.getSession().setAttribute("message", (Object)"Unable to contact DB. Please try again later.");
            response.sendRedirect("./registeredServices");
            return false;
        }
        return true;
    }

    private static String createServiceJson(String clientId, String name, String email) {
        ServiceRequest serviceJSON = new ServiceRequest();
        serviceJSON.setClientId(clientId);
        serviceJSON.setClientName(name);
        serviceJSON.setContacts(new String[]{email});
        serviceJSON.setToken_endpoint_auth_method("client_secret_basic");
        serviceJSON.setTokenEndpointAuthSigningAlg(null);
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        return gson.toJson((Object)serviceJSON);
    }

    private static String createServiceJson(String clientId, String name, String email, String jwksURI) {
        ServiceRequest serviceJSON = new ServiceRequest();
        serviceJSON.setClientId(clientId);
        serviceJSON.setClientName(name);
        serviceJSON.setContacts(new String[]{email});
        serviceJSON.setJwksUri(jwksURI);
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        return gson.toJson((Object)serviceJSON);
    }

    private static String createServiceJson(String clientId, String name, String email, Jwks jwks) {
        ServiceRequest serviceJSON = new ServiceRequest();
        serviceJSON.setClientId(clientId);
        serviceJSON.setClientName(name);
        serviceJSON.setContacts(new String[]{email});
        serviceJSON.setJwks(jwks);
        GsonBuilder builder = new GsonBuilder();
        builder.serializeNulls();
        Gson gson = builder.create();
        return gson.toJson((Object)serviceJSON);
    }
}

