/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import eu.dnetlib.openaire.user.utils.EmailSender;
import eu.dnetlib.openaire.user.utils.InputValidator;
import eu.dnetlib.openaire.user.utils.LDAPActions;
import eu.dnetlib.openaire.user.utils.VerificationActions;
import eu.dnetlib.openaire.user.utils.VerifyRecaptcha;
import eu.dnetlib.openaire.usermanagement.utils.UrlConstructor;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class RegisterServlet
extends HttpServlet {
    @Autowired
    private VerificationActions verificationActions;
    @Autowired
    private EmailSender emailSender;
    @Autowired
    private LDAPActions ldapActions;
    @Value(value="${google.recaptcha.secret}")
    private String secret;
    @Value(value="${google.recaptcha.key}")
    private String sitekey;
    private static Logger logger = Logger.getLogger(RegisterServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
        config.getServletContext().setAttribute("sitekey", (Object)this.sitekey);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter printWriter;
        block23: {
            response.setContentType("text/html");
            printWriter = response.getWriter();
            String firstName = request.getParameter("first_name").trim();
            String lastName = request.getParameter("last_name").trim();
            String organization = request.getParameter("organization").trim();
            String username = request.getParameter("username").trim();
            String email = request.getParameter("email").trim();
            String confirmEmail = request.getParameter("email_conf").trim();
            String password = request.getParameter("password");
            String confirmPassword = request.getParameter("password_conf");
            String gRecaptchaResponse = request.getParameter("g-recaptcha-response");
            boolean isRecaptchaVerified = VerifyRecaptcha.verify((String)gRecaptchaResponse, (String)this.secret);
            if (organization == null) {
                logger.info((Object)"organization is null");
            }
            if (firstName != null && lastName != null && username != null && email != null && email.equals(confirmEmail) && password != null && password.equals(confirmPassword) && EmailValidator.getInstance().isValid(email) && InputValidator.isValidPassword((String)password) && isRecaptchaVerified) {
                try {
                    if (InputValidator.isValidUsername((String)username) && !this.ldapActions.usernameExists(username) && !this.ldapActions.emailExists(email) && !this.ldapActions.isZombieUsersEmail(email) && !this.ldapActions.isZombieUsersUsername(username) && EmailValidator.getInstance().isValid(email)) {
                        this.ldapActions.createZombieUser(username, email, firstName, lastName, organization, password);
                        logger.info((Object)"Zombie user successfully created");
                        UUID verificationCode = UUID.randomUUID();
                        Date creationDate = new Date();
                        String vCode = verificationCode.toString();
                        Timestamp timestamp = new Timestamp(creationDate.getTime());
                        if (!this.verificationActions.verificationEntryExists(username)) {
                            this.verificationActions.addVerificationEntry(username, vCode, timestamp);
                        } else {
                            this.verificationActions.updateVerificationEntry(username, vCode, timestamp);
                        }
                        String resultPath = UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"activate.jsp");
                        String resultPathWithVCode = UrlConstructor.getVerificationLink((String)resultPath, (String)vCode);
                        String verificationCodeMsg = "<p>Hello " + username + ",</p><p> A request has been made to verify your email and activate your OpenAIRE account. To activate your account, you will need to submit your username and this activation code in order to verify that the request was legitimate.</p><p>The activation code is " + vCode + "</p>Click the URL below and proceed with activating your password.<p><a href=" + resultPathWithVCode + ">" + resultPathWithVCode + "</a></p><p>The activation code is valid for 24 hours.</p><p>Thank you,</p><p>OpenAIRE technical team</p>";
                        String verificationCodeSubject = "Activate your OpenAIRE account";
                        this.emailSender.sendEmail(email, verificationCodeSubject, verificationCodeMsg);
                        response.sendRedirect("./activate.jsp");
                        break block23;
                    }
                    this.validateUsername(request, username);
                    if (this.ldapActions.usernameExists(username) || this.ldapActions.isZombieUsersUsername(username)) {
                        request.getSession().setAttribute("username_message", (Object)"Username already exists! Choose another one.");
                        logger.info((Object)"Username already exists");
                    }
                    if (!EmailValidator.getInstance().isValid(email)) {
                        request.getSession().setAttribute("email_message", (Object)"Please enter a valid email.");
                        logger.info((Object)"Invalid email.");
                    }
                    if (this.ldapActions.emailExists(email)) {
                        request.getSession().setAttribute("email_message", (Object)"There is another user with this email.");
                        logger.info((Object)"There is another user with this email");
                    }
                    if (this.ldapActions.isZombieUsersEmail(email)) {
                        request.getSession().setAttribute("email_message", (Object)"You have already registered with this email address! Please check your email to activate your account or contact OpenAIRE <a href=\"https://www.openaire.eu/support/helpdesk\">helpdesk</a>.");
                        logger.info((Object)"There is another user with this email");
                    }
                    request.getSession().setAttribute("first_name", (Object)firstName);
                    request.getSession().setAttribute("msg_first_name_error_display", (Object)"display:none");
                    request.getSession().setAttribute("last_name", (Object)lastName);
                    request.getSession().setAttribute("msg_last_name_error_display", (Object)"display:none");
                    request.getSession().setAttribute("organization", (Object)organization);
                    request.getSession().setAttribute("username", (Object)username);
                    request.getSession().setAttribute("email", (Object)email);
                    request.getSession().setAttribute("msg_email_error_display", (Object)"display:none");
                    request.getSession().setAttribute("email_conf", (Object)confirmEmail);
                    request.getSession().setAttribute("msg_email_conf_error_display", (Object)"display:none");
                    request.getSession().setAttribute("msg_email_validation_error_display", (Object)"display:none");
                    request.getSession().setAttribute("msg_password_error_display", (Object)"display:none");
                    request.getSession().setAttribute("msg_pass_conf_error_display", (Object)"display:none");
                    request.getSession().setAttribute("msg_invalid_password_display", (Object)"display:none");
                    request.getSession().setAttribute("recaptcha_error_display", (Object)"display:none");
                    response.sendRedirect("./register.jsp");
                }
                catch (MessagingException e) {
                    logger.error((Object)"Error in sending email", (Throwable)e);
                    request.getSession().setAttribute("message", (Object)"Error sending email");
                    response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)".register.jsp"));
                }
                catch (Exception e) {
                    logger.error((Object)"LDAP error in creating user", (Throwable)e);
                    response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"error.jsp"));
                }
            } else {
                request.getSession().setAttribute("first_name", (Object)firstName);
                request.getSession().setAttribute("last_name", (Object)lastName);
                request.getSession().setAttribute("organization", (Object)organization);
                request.getSession().setAttribute("username", (Object)username);
                request.getSession().setAttribute("email", (Object)email);
                request.getSession().setAttribute("email_conf", (Object)confirmEmail);
                if (!InputValidator.isFilled((String)firstName)) {
                    logger.info((Object)"No first name");
                    request.getSession().setAttribute("msg_first_name_error_display", (Object)"display:block");
                }
                if (!InputValidator.isFilled((String)lastName)) {
                    logger.info((Object)"No last name");
                    request.getSession().setAttribute("msg_last_name_error_display", (Object)"display:block");
                }
                if (!InputValidator.isFilled((String)username)) {
                    request.getSession().setAttribute("username_message", (Object)"Minimum username length 5 characters.");
                    logger.info((Object)"No username");
                } else {
                    this.validateUsername(request, username);
                }
                if (!InputValidator.isFilled((String)password)) {
                    logger.info((Object)"No valid password");
                    request.getSession().setAttribute("msg_password_error_display", (Object)"display:block");
                }
                if (!EmailValidator.getInstance().isValid(email)) {
                    logger.info((Object)"No valid e-mail");
                    request.getSession().setAttribute("msg_email_validation_error_display", (Object)"display:block");
                }
                if (!email.equals(confirmEmail)) {
                    logger.info((Object)"No matching e-mails");
                    request.getSession().setAttribute("msg_email_conf_error_display", (Object)"display:block");
                }
                if (!InputValidator.isValidPassword((String)password)) {
                    logger.info((Object)"No valid password");
                    request.getSession().setAttribute("msg_invalid_password_display", (Object)"display:block");
                }
                if (!password.equals(confirmPassword)) {
                    logger.info((Object)"No matching passwords");
                    request.getSession().setAttribute("msg_pass_conf_error_display", (Object)"display:block");
                }
                if (!isRecaptchaVerified) {
                    logger.info((Object)"No valid recaptcha");
                    request.getSession().setAttribute("recaptcha_error_display", (Object)"display:block");
                }
                response.sendRedirect("./register.jsp");
            }
        }
        printWriter.close();
    }

    private void validateUsername(HttpServletRequest request, String username) {
        if (!InputValidator.isValidUsername((String)username)) {
            logger.info((Object)"No valid username");
            if (InputValidator.containsLessCharsThan((int)5, (String)username)) {
                request.getSession().setAttribute("username_message", (Object)"Minimum username length 5 characters.");
                logger.info((Object)"Minimum username length 5 characters.");
            }
            if (InputValidator.containsMoreCharsThan((int)150, (String)username)) {
                request.getSession().setAttribute("username_message", (Object)"Maximum username length 150 characters.");
                logger.info((Object)"Maximum username length 150 characters.");
            }
            if (!InputValidator.containsOnlyAllowedChars((String)username)) {
                request.getSession().setAttribute("username_allowed_chars_message", (Object)"You can use letters, numbers, underscores, hyphens and periods.");
                logger.info((Object)"Only letters, numbers, underscores, hyphens and periods.");
            }
            if (!InputValidator.startsWithLetterOrDigit((String)username)) {
                request.getSession().setAttribute("username_first_char_message", (Object)"The username must start with letter or digit.");
                logger.info((Object)"The username must start with letter or digit.");
            }
        }
    }
}

