/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.openaire.user.pojos.RegisteredService;
import eu.dnetlib.openaire.usermanagement.Jwks;
import eu.dnetlib.openaire.usermanagement.ServiceResponse;
import eu.dnetlib.openaire.usermanagement.utils.RegisteredServicesUtils;
import eu.dnetlib.openaire.usermanagement.utils.TokenUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpResponse;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class RegisteredServicesServlet
extends HttpServlet {
    private Logger logger = Logger.getLogger(RegisteredServicesServlet.class);
    @Autowired
    private RegisteredServicesUtils registeredServicesUtils;
    @Autowired
    private TokenUtils tokenUtils;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getSession().setAttribute("authenticated", (Object)(!SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString().equals("anonymousUser") ? 1 : 0));
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        String userId = authentication.getSub();
        List registeredServices = null;
        try {
            registeredServices = this.registeredServicesUtils.getRegisteredServiceDao().fetchAllRegisteredServicesByOwner(userId);
            if (registeredServices.isEmpty()) {
                request.getSession().setAttribute("showEmptyList", (Object)true);
            } else {
                HashMap<String, ServiceResponse> serviceResponses = new HashMap<String, ServiceResponse>();
                HashMap<String, String> serviceKey = new HashMap<String, String>();
                for (RegisteredService registeredService : registeredServices) {
                    ServiceResponse serviceResponse = this.tokenUtils.getRegisteredService(registeredService.getClientId(), registeredService.getRegistrationAccessToken());
                    serviceResponses.put(registeredService.getId(), serviceResponse);
                    serviceKey.put(registeredService.getId(), this.extractPublicKeySet(serviceResponse));
                }
                boolean reachedLimit = this.reachedMaximumNumberOfServices(registeredServices);
                StringBuilder name = new StringBuilder().append(authentication.getUserInfo().getGivenName().charAt(0));
                name.append(authentication.getUserInfo().getFamilyName().charAt(0));
                request.getSession().setAttribute("name", (Object)name.toString());
                request.getSession().setAttribute("reachedLimit", (Object)reachedLimit);
                request.getSession().setAttribute("services", serviceResponses);
                request.getSession().setAttribute("keys", serviceKey);
            }
            request.getSession().setAttribute("registeredServices", (Object)registeredServices);
        }
        catch (SQLException sqle) {
            this.logger.error((Object)("Error fetching registered services for user " + userId), (Throwable)sqle);
            request.getSession().setAttribute("message", (Object)"Error fetching registered services. Please try again later.");
            request.getSession().setAttribute("showEmptyList", (Object)false);
            request.getRequestDispatcher("./registeredServices.jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        response.setContentType("text/html");
        request.getRequestDispatcher("./registeredServices.jsp").include((ServletRequest)request, (ServletResponse)response);
    }

    private String extractPublicKeySet(ServiceResponse serviceResponse) {
        if (serviceResponse.getJwksUri() != null && !serviceResponse.getJwksUri().isEmpty()) {
            return serviceResponse.getJwksUri();
        }
        return this.extractJSONJwk(serviceResponse.getJwks());
    }

    private String extractJSONJwk(Jwks jwks) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)jwks);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        String id = request.getParameter("id");
        if (id != null && !id.isEmpty()) {
            try {
                RegisteredService registeredService = this.registeredServicesUtils.getRegisteredServiceDao().fetchRegisteredServiceById(Integer.parseInt(id));
                if (!registeredService.getOwner().equals(authentication.getSub())) {
                    request.getSession().setAttribute("message", (Object)"You are not allowed to delete the service.");
                    response.sendRedirect("./registeredServices");
                    return;
                }
                HttpResponse resp = this.tokenUtils.deleteService(registeredService.getClientId(), registeredService.getRegistrationAccessToken());
                int statusCode = resp.getStatusLine().getStatusCode();
                if (statusCode != 204) {
                    this.logger.error((Object)("Unable to delete the service. Status code was " + statusCode));
                    request.getSession().setAttribute("message", (Object)("Fail to delete the service. Status " + statusCode));
                    response.sendRedirect("./registeredServices");
                    return;
                }
                this.registeredServicesUtils.getRegisteredServiceDao().delete(Integer.parseInt(id));
                request.getSession().setAttribute("success", (Object)"The service was successfully deleted.");
            }
            catch (SQLException sqle) {
                this.logger.error((Object)"Unable to contact db.", (Throwable)sqle);
                request.getSession().setAttribute("message", (Object)"Fail to delete the service. Please try again later.");
            }
        } else {
            request.getSession().setAttribute("message", (Object)"Error selecting service to delete. Please try again.");
        }
        response.sendRedirect("./registeredServices");
    }

    private boolean reachedMaximumNumberOfServices(List<RegisteredService> registeredServices) {
        return registeredServices.size() >= 5;
    }
}

