/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement;

import eu.dnetlib.openaire.user.utils.EmailSender;
import eu.dnetlib.openaire.user.utils.LDAPActions;
import eu.dnetlib.openaire.user.utils.VerificationActions;
import eu.dnetlib.openaire.user.utils.VerifyRecaptcha;
import eu.dnetlib.openaire.usermanagement.utils.UrlConstructor;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

public class RequestActivationCodeServlet
extends HttpServlet {
    @Autowired
    private VerificationActions verificationActions;
    @Autowired
    private LDAPActions ldapActions;
    @Autowired
    private EmailSender emailSender;
    @Value(value="${oidc.home}")
    private String oidcHomeUrl;
    @Value(value="${google.recaptcha.secret}")
    private String secret;
    @Value(value="${google.recaptcha.key}")
    private String sitekey;
    private static final Logger logger = Logger.getLogger(RequestActivationCodeServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
        config.getServletContext().setAttribute("sitekey", (Object)this.sitekey);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String formUsername = request.getParameter("username").trim();
        String gRecaptchaResponse = request.getParameter("g-recaptcha-response");
        HttpSession session = request.getSession();
        session.setAttribute("homeUrl", (Object)this.oidcHomeUrl);
        if (formUsername == null) {
            request.getSession().setAttribute("message", (Object)"Error reading username.");
            response.sendRedirect("./requestActivationCode.jsp");
        } else if (formUsername.isEmpty()) {
            request.getSession().setAttribute("message", (Object)"Please enter your username.");
            response.sendRedirect("./requestActivationCode.jsp");
        } else if (!VerifyRecaptcha.verify((String)gRecaptchaResponse, (String)this.secret)) {
            request.getSession().setAttribute("reCAPTCHA_message", (Object)"You missed the reCAPTCHA validation!");
            response.sendRedirect("./requestActivationCode.jsp");
        } else {
            try {
                if (this.ldapActions.isZombieUsersUsername(formUsername)) {
                    logger.info((Object)("User " + formUsername + " is zombie user!"));
                    UUID verificationCode = UUID.randomUUID();
                    Date creationDate = new Date();
                    String vCode = verificationCode.toString();
                    Timestamp timestamp = new Timestamp(creationDate.getTime());
                    if (!this.verificationActions.verificationEntryExists(formUsername)) {
                        this.verificationActions.addVerificationEntry(formUsername, vCode, timestamp);
                    } else {
                        this.verificationActions.updateVerificationEntry(formUsername, vCode, timestamp);
                    }
                    String resultPath = UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"activate.jsp");
                    String resultPathWithVCode = UrlConstructor.getVerificationLink((String)resultPath, (String)vCode);
                    String verificationCodeMsg = "<p>Hello " + formUsername + ",</p><p> A request has been made to get a new activation code to verify your email and activate your OpenAIRE account. To activate your account, you will need to submit your username and this activation code in order to verify that the request was legitimate.</p><p>The activation code is " + vCode + "</p>Click the URL below and proceed with activating your password.<p><a href=" + resultPathWithVCode + ">" + resultPathWithVCode + "</a></p><p>The activation code is valid for 24 hours.</p><p>Thank you,</p><p>OpenAIRE technical team</p>";
                    String verificationCodeSubject = "Request a new activation code for your OpenAIRE account";
                    String email = this.ldapActions.getZombieUsersEmail(formUsername);
                    if (email != null && !email.isEmpty()) {
                        this.emailSender.sendEmail(email, verificationCodeSubject, verificationCodeMsg);
                        logger.info((Object)("Sending activation code to user: " + formUsername));
                    }
                    response.sendRedirect("./activate.jsp");
                } else if (this.ldapActions.usernameExists(formUsername)) {
                    logger.info((Object)("User " + formUsername + " has already activated his account."));
                    request.getSession().setAttribute("message", (Object)"Your account is already activated.");
                    response.sendRedirect("./requestActivationCode.jsp");
                } else {
                    logger.info((Object)("No user with username: " + formUsername));
                    request.getSession().setAttribute("message", (Object)"There is no user registered with that username.");
                    response.sendRedirect("./requestActivationCode.jsp");
                }
            }
            catch (MessagingException e) {
                logger.error((Object)"Error in sending email", (Throwable)e);
                request.getSession().setAttribute("message", (Object)"Error sending email");
                response.sendRedirect("./requestActivationCode.jsp");
            }
            catch (Exception ldape) {
                logger.error((Object)("Could not find zombie user with username " + formUsername), (Throwable)ldape);
                response.sendRedirect(UrlConstructor.getRedirectUrl((HttpServletRequest)request, (String)"error.jsp"));
            }
        }
    }

    public String getOidcHomeUrl() {
        return this.oidcHomeUrl;
    }

    public void setOidcHomeUrl(String oidcHomeUrl) {
        this.oidcHomeUrl = oidcHomeUrl;
    }
}

