/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.dnetlib.openaire.user.dao.SQLMigrationUserDAO;
import eu.dnetlib.openaire.user.ldap.MUserActionsLDAP;
import eu.dnetlib.openaire.user.login.utils.AuthoritiesMapper;
import eu.dnetlib.openaire.user.pojos.migration.LDAPUser;
import eu.dnetlib.openaire.user.store.DataSourceConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.mitre.openid.connect.model.UserInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Component(value="test3service")
@Path(value="/users")
public class Test3Service {
    private static final Logger logger = Logger.getLogger(Test3Service.class);
    public static final String errorMessage = "{ \"status\" : \"error\", \"code\" : \"%s\", \"message\" : \"%s\", \"description\" : \"%s\" }";
    @Autowired
    private SQLMigrationUserDAO sqlMigrationUserDAO;
    @Autowired
    private MUserActionsLDAP mUserActionsLDAP;
    @Autowired
    private DataSourceConnector dataSourceConnector;
    @Value(value="${oidc.issuer}")
    private String issuer;
    @Value(value="${oidc.secret}")
    private String secret;
    @Value(value="${oidc.id}")
    private String id;

    @GET
    @PreAuthorize(value="hasAuthority('ROLE_USER')")
    @Path(value="/getRefreshToken")
    public Response getRefreshToken() {
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        return Response.status((int)200).entity((Object)authentication.getRefreshTokenValue()).build();
    }

    @GET
    @PreAuthorize(value="hasAuthority('ROLE_USER')")
    @Path(value="/getJWTToken")
    public Response getAccessToken() {
        OIDCAuthenticationToken authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        return Response.status((int)200).entity((Object)authentication.getAccessTokenValue()).build();
    }

    @GET
    @Path(value="/getAccessToken")
    @Produces(value={"application/json"})
    public Response getAccessTokenFromRefreshToken(@Context HttpServletRequest request, @QueryParam(value="refreshToken") String refreshToken) {
        if (refreshToken == null || refreshToken.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format(errorMessage, 400, "Bad Request", "Missing refreshToken parameter")).type("application/json").build();
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httppost = new HttpPost(this.issuer + "/token");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.id));
        params.add(new BasicNameValuePair("client_secret", this.secret));
        params.add(new BasicNameValuePair("grant_type", "refresh_token"));
        params.add(new BasicNameValuePair("refresh_token", refreshToken));
        params.add(new BasicNameValuePair("scope", "openid"));
        CloseableHttpResponse response = null;
        try {
            httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == 401) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)String.format(errorMessage, 401, "Unauthorised", "Invalid refreshToken token " + refreshToken)).type("application/json").build();
            }
            String serverMessage = IOUtils.toString((InputStream)entity.getContent(), (String)StandardCharsets.UTF_8.name());
            return Response.status((int)response.getStatusLine().getStatusCode()).entity((Object)serverMessage).type("application/json").build();
        }
        catch (UnsupportedEncodingException uee) {
            logger.error((Object)uee);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format(errorMessage, 500, "Fail to get access token.", uee.getMessage())).type("application/json").build();
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format(errorMessage, 500, "Fail to get access token.", ioe.getMessage())).type("application/json").build();
        }
    }

    @GET
    @Path(value="/getToken")
    @Produces(value={"application/json"})
    public Response getToken(@QueryParam(value="accessToken") String accessToken) {
        block15: {
            logger.debug((Object)("Refresh token " + accessToken));
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httppost = new HttpPost(this.issuer + "/token");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("client_id", this.id));
            params.add(new BasicNameValuePair("client_secret", this.secret));
            params.add(new BasicNameValuePair("grant_type", "refresh_token"));
            params.add(new BasicNameValuePair("refresh_token", accessToken));
            params.add(new BasicNameValuePair("scope", "openid"));
            try {
                httppost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                CloseableHttpResponse response = null;
                response = httpclient.execute((HttpUriRequest)httppost);
                HttpEntity entity = response.getEntity();
                if (entity == null) break block15;
                try (InputStream instream = entity.getContent();){
                    logger.debug((Object)IOUtils.toString((InputStream)instream, (String)StandardCharsets.UTF_8.name()));
                }
            }
            catch (UnsupportedEncodingException uee) {
                logger.error((Object)uee);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format(errorMessage, 500, "Fail to get access token.", uee.getMessage())).type("application/json").build();
            }
            catch (IOException ioe) {
                logger.error((Object)ioe);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format(errorMessage, 500, "Fail to get access token.", ioe.getMessage())).type("application/json").build();
            }
        }
        return Response.status((int)200).type("application/json").build();
    }

    @GET
    @Path(value="/getUserInfo")
    @Produces(value={"application/json"})
    public Response getUserInfo(@QueryParam(value="accessToken") String accessToken) throws JsonProcessingException {
        logger.info((Object)accessToken);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setErrorHandler((ResponseErrorHandler)new /* Unavailable Anonymous Inner Class!! */);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + accessToken);
        org.springframework.http.HttpEntity request = new org.springframework.http.HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(this.issuer + "userinfo", HttpMethod.GET, request, String.class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK) {
            JsonObject userInfo = new JsonParser().parse((String)response.getBody()).getAsJsonObject();
            JsonArray roles = new JsonArray();
            AuthoritiesMapper.map((JsonArray)userInfo.get("edu_person_entitlements").getAsJsonArray()).forEach(grantedAuthority -> roles.add(grantedAuthority.getAuthority()));
            userInfo.add("roles", (JsonElement)roles);
            return Response.status((int)response.getStatusCode().value()).entity((Object)userInfo.toString()).type("application/json").build();
        }
        return Response.status((int)response.getStatusCode().value()).entity(response.getBody()).type("application/json").build();
    }

    @GET
    @Path(value="/getUser")
    @Produces(value={"application/json"})
    public Response getUser() {
        JsonObject userInfoJson = new JsonObject();
        try {
            OIDCAuthenticationToken authentication = null;
            try {
                authentication = (OIDCAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
            }
            catch (Exception e) {
                logger.info((Object)"Try to get User info - no context found ");
                return Response.status((int)404).entity((Object)this.compose404Message("Get User info: no context found ")).type("application/json").build();
            }
            UserInfo userInfo = authentication.getUserInfo();
            if (userInfo == null) {
                return Response.status((int)404).entity((Object)this.compose404Message("Get User info: user info is null ")).type("application/json").build();
            }
            logger.info((Object)("Get User:\n name: " + authentication.getUserInfo().getGivenName() + " " + authentication.getUserInfo().getFamilyName()));
            userInfoJson.addProperty("sub", userInfo.getSub());
            userInfoJson.addProperty("name", userInfo.getName());
            userInfoJson.addProperty("given_name", userInfo.getGivenName());
            userInfoJson.addProperty("family_name", userInfo.getFamilyName());
            userInfoJson.addProperty("email", userInfo.getEmail());
            JsonArray roles = new JsonArray();
            authentication.getAuthorities().forEach(grantedAuthority -> roles.add(grantedAuthority.getAuthority()));
            userInfoJson.add("roles", (JsonElement)roles);
        }
        catch (Exception e) {
            logger.error((Object)"Get User info: An error occurred ", (Throwable)e);
            return Response.status((int)500).entity((Object)this.compose500Message("Get User info: An error occurred ", e)).type("application/json").build();
        }
        return Response.status((int)200).entity((Object)userInfoJson.toString()).type("application/json").build();
    }

    private String compose401Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"401\", \"message\" : \"  " + message + " \" }";
    }

    private String compose404Message(String message) {
        return "{ \"status\" : \"error\", \"code\" : \"404\", \"message\" : \"  " + message + " \" }";
    }

    private String compose500Message(String message, Exception exception) {
        return "{ \"status\" : \"fail\", \"code\" : \"500\", \"message\" : \"  " + message + "\", \"description\" : \"" + exception.getMessage() + "\" }";
    }

    private String composeDataResponse(LDAPUser user) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + new Gson().toJson((Object)user) + " }";
    }

    private String composeDataResponse(String fullname) {
        return " { \"status\" : \"success\", \"code\": \"200\", \"data\" : " + new Gson().toJson((Object)fullname) + " }";
    }
}

