/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.utils;

import com.google.gson.JsonParser;
import java.util.Base64;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.mitre.openid.connect.model.OIDCAuthenticationToken;
import org.springframework.beans.factory.annotation.Value;

public class AuthenticationUtils {
    @Value(value="${oidc.issuer}")
    private String issuer;
    @Value(value="${oidc.secret}")
    private String secret;
    @Value(value="${oidc.id}")
    private String id;
    private Logger logger = Logger.getLogger(AuthenticationUtils.class);

    public static boolean isAuthenticated(OIDCAuthenticationToken authenticationToken) {
        return authenticationToken != null;
    }

    public static boolean hasJWTExpired(String accessToken) {
        String regex = "^([A-Za-z0-9-_=]+)\\.([A-Za-z0-9-_=]+)\\.?([A-Za-z0-9-_.+=]*)$";
        Matcher matcher = Pattern.compile(regex).matcher(accessToken);
        long exp = new JsonParser().parse(new String(Base64.getDecoder().decode(matcher.group(2)))).getAsJsonObject().get("exp").getAsLong();
        return exp - new Date().getTime() / 1000L <= 0L;
    }
}

