/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.usermanagement.utils;

import com.google.gson.JsonElement;
import eu.dnetlib.openaire.usermanagement.utils.AuthorizationService;
import eu.dnetlib.openaire.usermanagement.utils.HttpUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class RoleManagement {
    private static final Logger logger = Logger.getLogger(RoleManagement.class);
    @Value(value="${role-management.url}")
    private String url;
    public HttpUtils httpUtils;
    public AuthorizationService authorizationService;

    @Autowired
    public RoleManagement(HttpUtils httpUtils, AuthorizationService authorizationService) {
        this.httpUtils = httpUtils;
        this.authorizationService = authorizationService;
    }

    private String mapType(String type, boolean communityMap) {
        if (type.equals("organization")) {
            type = "institution";
        } else if (type.equals("ri") && communityMap) {
            type = "community";
        }
        return type;
    }

    public JsonElement assignMemberRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", "true");
        return this.httpUtils.post(this.url + "/member/" + this.mapType(type, false) + "/" + id, this.getSessionCookie(request), null, params);
    }

    public JsonElement assignManagerRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", "true");
        return this.httpUtils.post(this.url + "/admin/" + this.mapType(type, true) + "/" + id, this.getSessionCookie(request), null, params);
    }

    public JsonElement removeMemberRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("force", "true");
        return this.httpUtils.delete(this.url + "/member/" + this.mapType(type, false) + "/" + id, this.getSessionCookie(request), params);
    }

    public JsonElement removeMemberRole(String type, String id, String email) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        return this.httpUtils.delete(this.url + "/member/" + this.mapType(type, false) + "/" + id, null, params);
    }

    public JsonElement removeManagerRole(String type, String id, HttpServletRequest request) throws HttpClientErrorException {
        return this.httpUtils.delete(this.url + "/admin/" + this.mapType(type, true) + "/" + id, this.getSessionCookie(request), null);
    }

    public JsonElement removeManagerRole(String type, String id, String email) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        return this.httpUtils.delete(this.url + "/admin/" + this.mapType(type, true) + "/" + id, null, params);
    }

    public JsonElement getAllMembers(String type, String id) throws HttpClientErrorException {
        return this.httpUtils.get(this.url + "/member/" + this.mapType(type, false) + "/" + id, null, null);
    }

    public int getAllMembersCount(String type, String id) throws HttpClientErrorException {
        return this.httpUtils.get(this.url + "/member/" + this.mapType(type, false) + "/" + id + "/count", null, null).getAsInt();
    }

    public JsonElement getAllManagers(String type, String id) throws HttpClientErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!(this.authorizationService.isPortalAdmin() || this.authorizationService.isCurator(type) || this.authorizationService.isManager(type, id))) {
            params.put("name", "false");
            params.put("email", "false");
        }
        return this.httpUtils.get(this.url + "/admin/" + this.mapType(type, true) + "/" + id, null, params);
    }

    public JsonElement getAllCurators(String type) throws HttpClientErrorException {
        return this.httpUtils.get(this.url + "/curator/" + this.mapType(type, false), null, null);
    }

    public boolean isMember(String type, String id, String email) throws HttpClientErrorException {
        for (JsonElement element : this.httpUtils.get(this.url + "/member/" + this.mapType(type, false) + "/" + id, null, null).getAsJsonArray()) {
            if (!element.getAsJsonObject().get("email").getAsString().equalsIgnoreCase(email)) continue;
            return true;
        }
        return false;
    }

    public boolean isManager(String type, String id, String email) throws HttpClientErrorException {
        for (JsonElement element : this.httpUtils.get(this.url + "/admin/" + this.mapType(type, true) + "/" + id, null, null).getAsJsonArray()) {
            if (!element.getAsJsonObject().get("email").getAsString().equalsIgnoreCase(email)) continue;
            return true;
        }
        return false;
    }

    public JsonElement createMemberRole(String type, String id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("description", this.mapType(type, false) + " " + id);
        return this.httpUtils.post(this.url + "/member/" + this.mapType(type, false) + "/" + id + "/create", null, null, params);
    }

    public JsonElement createCuratorRole(String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("description", this.mapType(type, false) + " Curator");
        return this.httpUtils.post(this.url + "/curator/" + this.mapType(type, false) + "/create", null, null, params);
    }

    public JsonElement createRole(String name, String description) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", name);
        params.put("description", description);
        return this.httpUtils.post(this.url + "/super/create", null, null, params);
    }

    private String getSessionCookie(HttpServletRequest request) {
        return this.httpUtils.getCookie(request, "openAIRESession");
    }
}

