<%--
  Created by IntelliJ IDEA.
  User: sofia
  Date: 19/10/2017
  Time: 4:30 μμ
  To change this template use File | Settings | File Templates.
--%>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<!DOCTYPE html>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<html lang="en-gb" dir="ltr" vocab="http://schema.org/">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <base href=".">
    <title>OpenAIRE - APIs Authentication</title>
    <script src="./js/jquery.js"></script>
    <script src="./js/uikit.min.js"></script>
    <script src="./js/validation.js"></script>
    <script src="./js/uikit-icons-max.js"></script>
    <link rel="stylesheet" style="text/css" href="./css/theme.css">
    <link rel="stylesheet" style="text/css" href="./css/custom.css">
    <link rel="stylesheet" style="text/css" href="./css/aai-custom.css">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="images/favicon//favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon/favicon-16x16.png">
    <link href="images/favicon/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />
</head>
<body class="" style="">
<div class="uk-offcanvas-content uk-height-viewport">
    <!-- MENU STARTS HERE -->
    <jsp:include page="header.jsp"/>
    <!-- CONTENT STARTS HERE -->
    <div class="first_page_section uk-section-default uk-section uk-padding-remove-vertical">
        <div class="first_page_banner_headline uk-grid-collapse uk-flex-middle uk-margin-remove-vertical uk-grid" uk-grid="">
        </div>
    </div>
    <div class=" uk-section  uk-margin-small-top uk-container  " id="tm-main">
        <div class="uk-text-center">
            <!-- CENTER SIDE -->

            <h2 class="uk-h2 uk-margin-small-bottom">OpenAIRE APIs Authentication</h2>
            <div class="uk-margin-top">
                The OpenAIRE APIs can be accessed over HTTPS both by authenticated and unauthenticated requests.
                To achieve <b>better rate limits</b> you need to make <b>authenticated requests</b>.
            </div>

            <div class="uk-container uk-container-small uk-margin-top">

                <div class="uk-alert-primary uk-alert uk-margin-top-remove">
                    <span uk-icon="info"></span>
                    <span class="uk-margin-small-left">For more information please read the <a href="https://develop.openaire.eu/authentication.html" target="_blank">OpenAIRE API Authentication documentation</a>.</span>
                </div>

                <div class="uk-grid uk-child-width-1-2@m uk-child-width-1-1" uk-grid>
                    <div>
                        <div class="uk-card uk-card-default uk-card-body">
                            <div class=""> <a class="uk-link uk-text-large" href="./personalToken"> Personal token</a></div>
                            <div>Get access to the OpenAIRE APIs with your personal access and refresh token.</div>
                        </div>
                    </div>
                    <div>
                        <div class="uk-card uk-card-default uk-card-body ">
                            <div class=""> <a class="uk-link uk-text-large" href="./registeredServices"> Registered Services</a></div>
                            <div>Register your services to get access to the OpenAIRE APIs.</div>
                        </div>
                    </div>
                </div>

            </div>
            <!-- END OF CENTER SIDE -->
        </div>
    </div>
    <!-- CONTENT ENDS HERE -->
    <c:import url="footer.jsp"/>
</div>
</body>
</html>
