<!DOCTYPE html>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<html lang="en-gb" dir="ltr" vocab="http://schema.org/">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>OpenAIRE - Personal token</title>
    <script src="./js/jquery.js"></script>
    <script src="./js/uikit.min.js"></script>
    <script src="./js/uikit-icons-max.js"></script>
    <script>
        function copy(id) {
            var element = document.getElementById(id);
            if (document.body.createTextRange) {
                range = document.body.createTextRange();
                range.moveToElementText(element);
                range.select();
            } else if (window.getSelection) {
                selection = window.getSelection();
                range = document.createRange();
                range.selectNodeContents(element);
                selection.removeAllRanges();
                selection.addRange(range);
            }
            try {
                document.execCommand('copy');
                UIkit.notification({message: 'Copied to clipboard!', status: 'primary', pos: 'top-right'});
            } catch (err) {
                console.error('unable to copy text');
            }
        }
        $(document).ready(function () {
            document.addEventListener('copy', (event) => {
                const selection = document.getSelection();
                event.clipboardData.setData('text/plain', selection.toString().trim());
                event.preventDefault();
            });
        });
    </script>
    <link rel="stylesheet" style="text/css" href="./css/theme.css">
    <link rel="stylesheet" style="text/css" href="./css/custom.css">
    <link rel="stylesheet" style="text/css" href="./css/aai-custom.css">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="images/favicon//favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon/favicon-16x16.png">
    <link href="images/favicon/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon"/>
</head>
<body class="" style="">
<div class="uk-offcanvas-content uk-height-viewport">
    <jsp:include page="header.jsp"/>
    <div class="first_page_section uk-section-default uk-section uk-padding-remove-vertical">
        <div class="first_page_banner_headline uk-grid-collapse uk-flex-middle uk-margin-remove-vertical uk-grid"
             uk-grid="">
        </div>
    </div>
    <div class=" uk-section  uk-margin-small-top uk-container uk-container-large" id="tm-main">
        <div class="uk-grid ">
            <div class="uk-width-1-4@m">
                <div class="uk-card uk-card-default uk-card-body">
                    <div class="uk-h4">API Access</div>
                    <ul class="uk-nav uk-nav-default">
                        <li class="uk-active"><a href="./personalToken">Personal token</a></li>
                        <li class=""><a href="./registeredServices">Registered services</a></li>
                        <%--<li class="uk-parent">
                          <a href="#">Parent</a>
                          <ul class="uk-nav-sub">
                            <li><a href="#">Sub item</a></li>
                            <li>
                              <a href="#">Sub item</a>
                              <ul>
                                <li><a href="#">Sub item</a></li>
                                <li><a href="#">Sub item</a></li>
                              </ul>
                            </li>
                          </ul>
                        </li>--%>
                    </ul>
                </div>
            </div>
            <!-- CENTER SIDE -->
            <div class="uk-width-2-3@l uk-width-2-3@m">
                <div>
                    <span id="server_error" class="uk-text-danger uk-text-small uk-float-left">${message}</span>
                    <c:remove var="message" scope="session"/>
                    <div class="uk-alert-primary uk-margin-remove-top uk-alert uk-flex uk-flex-middle">
                        <span uk-icon="info"></span>
                        <span class="uk-margin-small-left">
                            For further information on how to use the tokens please visit the
                            <a href="https://develop.openaire.eu/personalToken.html" target="_blank">OpenAIRE API Authentication documentation</a>.
                        </span>
                    </div>
                    <form id="revoke" name="revoke" action="./personalToken" method="post">
                        <!-- <a  class=" uk-text-danger uk-float-right" title="Revoke access token" onClick="document.revoke.submit();"><span uk-icon="refresh" ></span></a> -->
                        <h4 class="uk-margin-remove-top uk-text-bold uk-text-primary">Your personal access token is</h4>
                        <div class="uk-flex uk-flex-middle uk-margin-bottom">
                            <div class="uk-width-expand">
                                <pre class="uk-margin-remove-bottom"><code id="accessToken">${accessToken}</code></pre>
                            </div>
                            <div class="uk-width-auto uk-padding-small uk-text-center">
                                <a onclick="copy('accessToken')"
                                   title="Copy access token"><span uk-icon="copy"></span>
                                </a>
                            </div>
                        </div>
                        <div class="uk-flex uk-flex-middle">
                            <span uk-icon="info"></span>
                            <span class="uk-margin-small-left">
                                Your access token is <span class="uk-text-bold">valid for an hour</span>.
                            </span>
                        </div>
                        <div class="uk-text-danger uk-flex uk-flex-middle uk-margin-small-top">
                            <span uk-icon="warning"></span>
                            <span class="uk-margin-small-left">
                                Do not share your personal access token. Send your personal access token only over HTTPS.
                            </span>
                        </div>
                    </form>
                </div>
                <div class="uk-section">
                    <!--<a  class=" uk-text-danger uk-float-right" title="Revoke refresh token"><span uk-icon="refresh"></span></a>-->
                    <c:choose>
                        <c:when test="${showRefreshToken == true}">
                            <h4 class="uk-margin-remove-top uk-text-bold uk-text-primary">Your refresh token is</h4>
                            <div class="uk-flex uk-flex-middle uk-margin-bottom">
                                <div class="uk-width-expand">
                                    <pre class="uk-margin-remove-bottom"><code id="refreshToken">${refreshToken}</code></pre>
                                </div>
                                <div class="uk-width-auto uk-padding-small uk-text-center">
                                    <a onclick="copy('refreshToken')"
                                       title="Copy refreshToken token"><span uk-icon="copy"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="uk-flex uk-flex-middle">
                                <span uk-icon="info"></span>
                                <span class="uk-margin-small-left">OpenAIRE refresh token <span class="uk-text-bold">expires after 1 month</span> and allows you to programmatically get a new access token.</span>
                            </div>
                            <div class="uk-text-danger uk-flex uk-flex-middle uk-margin-small-top">
                                <span uk-icon="warning"></span>
                                <div class="uk-margin-small-left">
                                    <div>Please copy your refresh token and store it confidentially. You will not be able to retrieve it.</div>
                                    <div>Do not share your refresh token. Send your refresh token only over HTTPS.</div>
                                </div>
                            </div>
                        </c:when>
                        <c:otherwise>
                            <h4 class="uk-margin-remove-top uk-text-bold uk-text-primary">Do you need a refresh token?</h4>
                            <div class="uk-flex uk-flex-middle">
                                <span uk-icon="info"></span>
                                <span class="uk-margin-small-left">OpenAIRE refresh token <span class="uk-text-bold">expires after 1 month</span> and allows you to programmatically get a new access token.</span>
                            </div>
                            <button type="submit" class="uk-button uk-button-primary uk-margin-medium-top" uk-toggle="target: #refreshWarning">Get a
                                refresh token
                            </button>
                        </c:otherwise>
                    </c:choose>

                </div>

                <!-- This is the modal -->
                <div id="refreshWarning" uk-modal>
                    <div class="uk-modal-dialog uk-modal-body">
                        <form id="refreshForm" action="./personalToken" method="POST">
                            <h2 class="uk-modal-title">Get refresh token</h2>
                            <p>In case you already have a refresh token, it will no longer be valid. Do you want to
                                proceed?</p>
                            <p class="uk-text-right">
                                <button class="uk-button uk-button-default uk-modal-close" type="button">Cancel</button>
                                <button class="uk-button uk-button-primary uk-margin-small-left" type="button" onclick="submit();">Get
                                    refresh token
                                </button>
                            </p>
                        </form>
                    </div>
                </div>
            </div>

            <!-- END OF CENTER SIDE -->
        </div>
    </div>
    <!-- CONTENT ENDS HERE -->
    <c:import url="footer.jsp"/>
</div>
</body>
</html>
