package eu.dnetlib.openaire.usermanagement.utils;

import eu.dnetlib.openaire.user.pojos.RegisteredService;
import eu.dnetlib.openaire.user.registeredService.RegisteredServiceDao;
import eu.dnetlib.openaire.user.registeredService.RegisteredServiceSQL;
import org.springframework.stereotype.Component;

import java.sql.SQLException;

@Component
public class RegisteredServicesUtils {

    RegisteredServiceDao registeredServiceDao = new RegisteredServiceSQL();

    public RegisteredServiceDao getRegisteredServiceDao() {
        return registeredServiceDao;
    }

    public void setRegisteredServiceDao(RegisteredServiceDao registeredServiceDao) {
        this.registeredServiceDao = registeredServiceDao;
    }

    public void addRegistedService(RegisteredService registeredService) throws SQLException {
        registeredServiceDao.insertRegisteredService(registeredService);
    }

    public boolean isAuthorized(String userid, int id) throws SQLException {
        RegisteredService registeredService = registeredServiceDao.fetchRegisteredServiceById(id);
        if (registeredService == null) {
            return false; //no harm in accessing nothing
        }
        return registeredService.getOwner().equals(userid);
    }

}
